/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.doc;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfWriter;
import java.io.OutputStream;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.drools.verifier.doc.DroolsDocsComponentFactory;
import org.drools.verifier.misc.DrlPackageParser;
import org.drools.verifier.misc.DrlRuleParser;

public class DroolsDocsBuilder {
    protected final String currentDate = DroolsDocsBuilder.getFormatter().format(new Date());
    private final DrlPackageParser packageData;

    protected static Format getFormatter() {
        return new SimpleDateFormat(DroolsDocsBuilder.getDateFormatMask());
    }

    public DroolsDocsBuilder(String packageDrl) throws ParseException {
        this.packageData = DrlPackageParser.findPackageDataFromDrl(packageDrl);
    }

    protected DroolsDocsBuilder(DrlPackageParser packageData) {
        this.packageData = packageData;
    }

    public static DroolsDocsBuilder getInstance(String packageDrl) throws ParseException {
        return new DroolsDocsBuilder(packageDrl);
    }

    public static DroolsDocsBuilder getInstance(DrlPackageParser packageData) {
        return new DroolsDocsBuilder(packageData);
    }

    public void writePDF(OutputStream out) {
        Document document = new Document();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)out);
            HeaderFooter footer = DroolsDocsComponentFactory.createFooter(this.packageData.getName());
            document.setFooter(footer);
            document.addTitle(this.packageData.getName().toUpperCase());
            document.open();
            DroolsDocsComponentFactory.createFirstPage(document, this.currentDate, this.packageData);
            document.newPage();
            document.add((Element)new Phrase("Table of Contents"));
            document.add((Element)DroolsDocsComponentFactory.createContents(this.packageData.getRules()));
            document.newPage();
            for (DrlRuleParser ruleData : this.packageData.getRules()) {
                DroolsDocsComponentFactory.newRulePage(document, this.packageData.getName(), ruleData);
            }
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        document.close();
    }

    public static String getDateFormatMask() {
        String fmt = System.getProperty("drools.dateformat");
        if (fmt == null) {
            fmt = "dd-MMM-yyyy";
        }
        return fmt;
    }
}

