/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl.datasources;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.DefaultEventHandle;
import org.drools.ruleunits.api.DataProcessor;
import org.drools.ruleunits.api.DataStream;
import org.kie.api.time.SessionPseudoClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListDataStream<T>
implements DataStream<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventListDataStream.class);
    private final ArrayList<T> values = new ArrayList();
    private final List<DataProcessor> subscribers = new ArrayList<DataProcessor>();

    @SafeVarargs
    public static <T> EventListDataStream<T> create(T ... ts) {
        EventListDataStream<T> stream = new EventListDataStream<T>();
        for (T t : ts) {
            stream.append(t);
        }
        return stream;
    }

    public void append(T t) {
        this.values.add(t);
        for (DataProcessor subscriber : this.subscribers) {
            this.insertAndAdvanceClock(t, subscriber);
        }
    }

    public void subscribe(DataProcessor subscriber) {
        this.subscribers.add(subscriber);
        this.values.forEach(v -> this.insertAndAdvanceClock(v, subscriber));
    }

    private void insertAndAdvanceClock(T t, DataProcessor subscriber) {
        WorkingMemoryEntryPoint ep;
        SessionPseudoClock clock;
        DefaultEventHandle fh = (DefaultEventHandle)subscriber.insert(null, t);
        long timestamp = fh.getStartTimestamp();
        long advanceTime = timestamp - (clock = (SessionPseudoClock)(ep = fh.getEntryPoint(null)).getReteEvaluator().getSessionClock()).getCurrentTime();
        if (advanceTime > 0L) {
            clock.advanceTime(advanceTime, TimeUnit.MILLISECONDS);
        } else if (advanceTime < 0L) {
            LOGGER.warn("Received an event with a timestamp that is " + -advanceTime + " milliseconds in the past. Evaluation of out of order events could lead to unpredictable results.");
        }
    }
}

