/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.drools.model.DSL;
import org.drools.model.Global;
import org.drools.model.Model;
import org.drools.model.impl.ModelImpl;
import org.drools.ruleunits.dsl.RuleFactory;
import org.drools.ruleunits.dsl.RuleUnitDefinition;
import org.drools.ruleunits.dsl.UnitGlobalsResolver;
import org.drools.ruleunits.dsl.util.RuleDefinition;

public class RulesFactory {
    private final RuleUnitDefinition unit;
    private final List<RuleDefinition> rules = new ArrayList<RuleDefinition>();
    private final UnitGlobals globals;

    public RulesFactory(RuleUnitDefinition unit) {
        this.unit = unit;
        this.globals = new UnitGlobals(unit);
    }

    public RuleFactory rule() {
        return this.rule(UUID.randomUUID().toString());
    }

    public RuleFactory rule(String name) {
        RuleDefinition rule = new RuleDefinition(name, this.unit, this.globals);
        this.rules.add(rule);
        return rule;
    }

    Model toModel() {
        ModelImpl model = new ModelImpl();
        this.globals.getGlobals().values().forEach(arg_0 -> ((ModelImpl)model).addGlobal(arg_0));
        this.rules.stream().map(RuleDefinition::toRule).forEach(arg_0 -> ((ModelImpl)model).addRule(arg_0));
        return model;
    }

    UnitGlobalsResolver getUnitGlobalsResolver() {
        return new UnitGlobalsResolver(this.globals.fieldByGlobal);
    }

    public static class UnitGlobals {
        private final Map<Object, Global> globals = new IdentityHashMap<Object, Global>();
        private final Map<String, RuleDefinition.FieldDefinition> fieldByGlobal = new HashMap<String, RuleDefinition.FieldDefinition>();
        private final String unitName;

        private UnitGlobals(RuleUnitDefinition unit) {
            this.unitName = unit.getClass().getCanonicalName();
        }

        private Map<Object, Global> getGlobals() {
            return this.globals;
        }

        public <T> Global asGlobal(Supplier<RuleDefinition.FieldDefinition> globalField, T globalObject) {
            return this.globals.computeIfAbsent(globalObject, o -> this.registerGlobal(globalField, o));
        }

        private Global<?> registerGlobal(Supplier<RuleDefinition.FieldDefinition> globalField, Object globalObject) {
            String globalUUID = UUID.randomUUID().toString();
            this.fieldByGlobal.put(globalUUID, globalField.get());
            return DSL.globalOf(globalObject.getClass(), (String)this.unitName, (String)globalUUID);
        }
    }
}

