/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.parser.ast.expr;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.BinaryExprMetaModel;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.printer.Printable;
import com.github.javaparser.utils.Utils;
import org.drools.mvel.parser.ast.visitor.DrlGenericVisitor;
import org.drools.mvel.parser.ast.visitor.DrlVoidVisitor;

public final class HalfBinaryExpr
extends Expression {
    private Expression right;
    private Operator operator;

    public HalfBinaryExpr() {
        this(null, (Expression)new BooleanLiteralExpr(), Operator.EQUALS);
    }

    @AllFieldsConstructor
    public HalfBinaryExpr(Expression right, Operator operator) {
        this(null, right, operator);
    }

    public HalfBinaryExpr(TokenRange tokenRange, Expression right, Operator operator) {
        super(tokenRange);
        this.setRight(right);
        this.setOperator(operator);
        this.customInitialization();
    }

    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return ((DrlGenericVisitor)v).visit(this, arg);
    }

    public <A> void accept(VoidVisitor<A> v, A arg) {
        ((DrlVoidVisitor)v).visit(this, arg);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getRight() {
        return this.right;
    }

    public HalfBinaryExpr setOperator(Operator operator) {
        Utils.assertNotNull((Object)((Object)operator));
        if (operator == this.operator) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.OPERATOR, (Object)this.operator, (Object)operator);
        this.operator = operator;
        return this;
    }

    public HalfBinaryExpr setRight(Expression right) {
        Utils.assertNotNull((Object)right);
        if (right == this.right) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.RIGHT, this.right, right);
        if (this.right != null) {
            this.right.setParentNode(null);
        }
        this.right = right;
        this.setAsParentNodeOf((Node)right);
        return this;
    }

    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    public HalfBinaryExpr clone() {
        return (HalfBinaryExpr)((Object)this.accept((GenericVisitor)new CloneVisitor(), null));
    }

    public BinaryExprMetaModel getMetaModel() {
        return JavaParserMetaModel.binaryExprMetaModel;
    }

    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (node == this.right) {
            this.setRight((Expression)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    public static enum Operator implements Printable
    {
        EQUALS("=="),
        NOT_EQUALS("!="),
        LESS("<"),
        GREATER(">"),
        LESS_EQUALS("<="),
        GREATER_EQUALS(">=");

        private final String codeRepresentation;

        private Operator(String codeRepresentation) {
            this.codeRepresentation = codeRepresentation;
        }

        public String asString() {
            return this.codeRepresentation;
        }

        public BinaryExpr.Operator toBinaryExprOperator() {
            switch (this) {
                case EQUALS: {
                    return BinaryExpr.Operator.EQUALS;
                }
                case NOT_EQUALS: {
                    return BinaryExpr.Operator.NOT_EQUALS;
                }
                case LESS: {
                    return BinaryExpr.Operator.LESS;
                }
                case GREATER: {
                    return BinaryExpr.Operator.GREATER;
                }
                case LESS_EQUALS: {
                    return BinaryExpr.Operator.LESS_EQUALS;
                }
                case GREATER_EQUALS: {
                    return BinaryExpr.Operator.GREATER_EQUALS;
                }
            }
            throw new UnsupportedOperationException("Unknown operator " + (Object)((Object)this));
        }
    }
}

