/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.core.addon.TypeResolver;
import org.drools.core.factmodel.ClassBuilder;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.ClassUtils;
import org.drools.reflective.classloader.ProjectClassLoader;

public class DeclaredClassBuilder {
    protected final KnowledgeBuilderImpl kbuilder;

    public DeclaredClassBuilder(KnowledgeBuilderImpl kbuilder) {
        this.kbuilder = kbuilder;
    }

    public void generateBeanFromDefinition(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, PackageRegistry pkgRegistry, ClassDefinition def) {
        if (type.isNovel()) {
            String fullName = typeDescr.getType().getFullName();
            JavaDialectRuntimeData dialect = (JavaDialectRuntimeData)pkgRegistry.getDialectRuntimeRegistry().getDialectData("java");
            if (this.ensureJavaTypeConsistency(typeDescr, def, pkgRegistry.getTypeResolver())) {
                switch (type.getKind()) {
                    case TRAIT: {
                        try {
                            this.buildClass(def, fullName, dialect, this.kbuilder.getBuilderConfiguration().getClassBuilderFactory().getTraitBuilder(), pkgRegistry);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Unable to compile declared trait " + fullName + ": " + e.getMessage() + ";"));
                        }
                        break;
                    }
                    case ENUM: {
                        try {
                            this.buildClass(def, fullName, dialect, (ClassBuilder)this.kbuilder.getBuilderConfiguration().getClassBuilderFactory().getEnumClassBuilder(), pkgRegistry);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Unable to compile declared enum " + fullName + ": " + e.getMessage() + ";"));
                        }
                        break;
                    }
                    default: {
                        try {
                            this.buildClass(def, fullName, dialect, this.kbuilder.getBuilderConfiguration().getClassBuilderFactory().getBeanClassBuilder(), pkgRegistry);
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Unable to create a class for declared type " + fullName + ": " + e.getMessage() + ";"));
                        }
                    }
                }
            }
        }
    }

    private boolean ensureJavaTypeConsistency(AbstractClassTypeDeclarationDescr typeDescr, ClassDefinition def, TypeResolver typeResolver) {
        try {
            if (typeDescr instanceof TypeDeclarationDescr && !((TypeDeclarationDescr)typeDescr).isTrait() && typeResolver.resolveType(def.getSuperClass()).isInterface()) {
                def.addInterface(def.getSuperClass());
                def.setSuperClass(null);
            }
            for (String sup : def.getInterfaces()) {
                if (typeResolver.resolveType(sup).isInterface()) continue;
                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Non-interface type used as super interface : " + sup));
                return false;
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Unable to resolve parent type :" + cnfe.getMessage()));
            return false;
        }
        return true;
    }

    protected void buildClass(ClassDefinition def, String fullName, JavaDialectRuntimeData dialect, ClassBuilder cb, PackageRegistry pkgRegistry) throws Exception {
        byte[] bytecode = cb.buildClass(def, this.kbuilder.getRootClassLoader());
        String resourceName = ClassUtils.convertClassToResourcePath((String)fullName);
        dialect.putClassDefinition(resourceName, bytecode);
        if (this.kbuilder.getKnowledgeBase() != null) {
            Class clazz = this.kbuilder.getKnowledgeBase().registerAndLoadTypeDefinition(fullName, bytecode);
            pkgRegistry.getTypeResolver().registerClass(fullName, clazz);
        } else if (this.kbuilder.getRootClassLoader() instanceof ProjectClassLoader) {
            Class clazz = ((ProjectClassLoader)this.kbuilder.getRootClassLoader()).defineClass(fullName, resourceName, bytecode);
            pkgRegistry.getTypeResolver().registerClass(fullName, clazz);
        } else {
            dialect.write(resourceName, bytecode);
        }
    }
}

