/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.MismatchedNotSetException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.MismatchedTreeNodeException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.drools.compiler.DroolsParserException;
import org.drools.lang.DroolsParaphraseTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsParserExceptionFactory {
    public static final String MISMATCHED_TOKEN_MESSAGE_COMPLETE = "Line %1$d:%2$d mismatched input '%3$s' expecting '%4$s'%5$s";
    public static final String MISMATCHED_TOKEN_MESSAGE_PART = "Line %1$d:%2$d mismatched input '%3$s'%4$s";
    public static final String MISMATCHED_TREE_NODE_MESSAGE_COMPLETE = "Line %1$d:%2$d mismatched tree node '%3$s' expecting '%4$s'%5$s";
    public static final String MISMATCHED_TREE_NODE_MESSAGE_PART = "Line %1$d:%2$d mismatched tree node '%3$s'%4$s";
    public static final String NO_VIABLE_ALT_MESSAGE = "Line %1$d:%2$d no viable alternative at input '%3$s'%4$s";
    public static final String EARLY_EXIT_MESSAGE = "Line %1$d:%2$d required (...)+ loop did not match anything at input '%3$s'%4$s";
    public static final String MISMATCHED_SET_MESSAGE = "Line %1$d:%2$d mismatched input '%3$' expecting set '%4$s'%5$s.";
    public static final String MISMATCHED_NOT_SET_MESSAGE = "Line %1$d:%2$d mismatched input '%3$' expecting set '%4$s'%5$s";
    public static final String FAILED_PREDICATE_MESSAGE = "Line %1$d:%2$d rule '%3$s' failed predicate: {%4$s}?%5$s";
    public static final String TRAILING_SEMI_COLON_NOT_ALLOWED_MESSAGE = "Line %1$d:%2$d trailing semi-colon not allowed%3$s";
    public static final String PARSER_LOCATION_MESSAGE_COMPLETE = " in %1$s %2$s";
    public static final String PARSER_LOCATION_MESSAGE_PART = " in %1$s";
    private String[] tokenNames = null;
    private Stack<Map<DroolsParaphraseTypes, String>> paraphrases = null;

    public DroolsParserExceptionFactory(String[] tokenNames, Stack<Map<DroolsParaphraseTypes, String>> paraphrases) {
        this.tokenNames = tokenNames;
        this.paraphrases = paraphrases;
    }

    public DroolsParserException createTrailingSemicolonException(int line, int column, int offset) {
        String message = String.format(TRAILING_SEMI_COLON_NOT_ALLOWED_MESSAGE, line, column, this.formatParserLocation());
        return new DroolsParserException("ERR 104", message, line, column, offset, null);
    }

    public DroolsParserException createDroolsException(RecognitionException e) {
        List<String> codeAndMessage = this.createErrorMessage(e);
        return new DroolsParserException(codeAndMessage.get(1), codeAndMessage.get(0), e.line, e.charPositionInLine, e.index, e);
    }

    private List<String> createErrorMessage(RecognitionException e) {
        ArrayList<String> codeAndMessage = new ArrayList<String>(2);
        String message = "";
        if (e instanceof MismatchedTokenException) {
            MismatchedTokenException mte = (MismatchedTokenException)e;
            if (this.tokenNames != null && mte.expecting >= 0 && mte.expecting < this.tokenNames.length) {
                message = String.format(MISMATCHED_TOKEN_MESSAGE_COMPLETE, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.getBetterToken(mte.expecting), this.formatParserLocation());
                codeAndMessage.add(message);
                codeAndMessage.add("ERR 102");
            } else {
                message = String.format(MISMATCHED_TOKEN_MESSAGE_PART, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.formatParserLocation());
                codeAndMessage.add(message);
                codeAndMessage.add("ERR 102");
            }
        } else if (e instanceof MismatchedTreeNodeException) {
            MismatchedTreeNodeException mtne = (MismatchedTreeNodeException)e;
            if (mtne.expecting >= 0 && mtne.expecting < this.tokenNames.length) {
                message = String.format(MISMATCHED_TREE_NODE_MESSAGE_COMPLETE, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.getBetterToken(mtne.expecting), this.formatParserLocation());
                codeAndMessage.add(message);
                codeAndMessage.add("ERR 106");
            } else {
                message = String.format(MISMATCHED_TREE_NODE_MESSAGE_PART, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.formatParserLocation());
                codeAndMessage.add(message);
                codeAndMessage.add("ERR 106");
            }
        } else if (e instanceof NoViableAltException) {
            message = String.format(NO_VIABLE_ALT_MESSAGE, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 101");
        } else if (e instanceof EarlyExitException) {
            message = String.format(EARLY_EXIT_MESSAGE, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 105");
        } else if (e instanceof MismatchedSetException) {
            MismatchedSetException mse = (MismatchedSetException)e;
            message = String.format(MISMATCHED_SET_MESSAGE, e.line, e.charPositionInLine, this.getBetterToken(e.token), mse.expecting, this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 107");
        } else if (e instanceof MismatchedNotSetException) {
            MismatchedNotSetException mse = (MismatchedNotSetException)e;
            message = String.format(MISMATCHED_NOT_SET_MESSAGE, e.line, e.charPositionInLine, this.getBetterToken(e.token), mse.expecting, this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 108");
        } else if (e instanceof FailedPredicateException) {
            FailedPredicateException fpe = (FailedPredicateException)e;
            message = String.format(FAILED_PREDICATE_MESSAGE, e.line, e.charPositionInLine, fpe.ruleName, fpe.predicateText, this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 103");
        }
        if (((String)codeAndMessage.get(0)).length() == 0) {
            codeAndMessage.add("?????");
        }
        return codeAndMessage;
    }

    private String formatParserLocation() {
        StringBuilder sb = new StringBuilder();
        if (this.paraphrases != null) {
            for (Map map : this.paraphrases) {
                for (Map.Entry activeEntry : map.entrySet()) {
                    if (((String)activeEntry.getValue()).length() == 0) {
                        sb.append(String.format(PARSER_LOCATION_MESSAGE_PART, this.getLocationName((DroolsParaphraseTypes)((Object)activeEntry.getKey()))));
                        continue;
                    }
                    sb.append(String.format(PARSER_LOCATION_MESSAGE_COMPLETE, this.getLocationName((DroolsParaphraseTypes)((Object)activeEntry.getKey())), activeEntry.getValue()));
                }
            }
        }
        return sb.toString();
    }

    private String getLocationName(DroolsParaphraseTypes type) {
        switch (type) {
            case PACKAGE: {
                return "package";
            }
            case IMPORT: {
                return "import";
            }
            case FUNCTION_IMPORT: {
                return "function import";
            }
            case GLOBAL: {
                return "global";
            }
            case FUNCTION: {
                return "function";
            }
            case QUERY: {
                return "query";
            }
            case TEMPLATE: {
                return "template";
            }
            case RULE: {
                return "rule";
            }
            case RULE_ATTRIBUTE: {
                return "rule attribute";
            }
            case PATTERN: {
                return "pattern";
            }
        }
        return "";
    }

    private String getBetterToken(Token token) {
        if (token == null) {
            return "";
        }
        return this.getBetterToken(token.getType(), token.getText());
    }

    private String getBetterToken(int tokenType) {
        return this.getBetterToken(tokenType, null);
    }

    private String getBetterToken(int tokenType, String defaultValue) {
        switch (tokenType) {
            case 94: {
                return defaultValue == null ? "int" : defaultValue;
            }
            case 108: {
                return defaultValue == null ? "float" : defaultValue;
            }
            case 85: {
                return defaultValue == null ? "string" : defaultValue;
            }
            case 93: {
                return defaultValue == null ? "boolean" : defaultValue;
            }
            case 109: {
                return "null";
            }
            case 112: {
                return "then";
            }
            case 81: {
                return ";";
            }
            case 84: {
                return ".*";
            }
            case 90: {
                return ":";
            }
            case 102: {
                return "==";
            }
            case 107: {
                return "!=";
            }
            case 103: {
                return ">";
            }
            case 104: {
                return ">=";
            }
            case 105: {
                return "<";
            }
            case 106: {
                return "<=";
            }
            case 101: {
                return "->";
            }
            case 82: {
                return defaultValue == null ? "identifier" : defaultValue;
            }
            case 86: {
                return "(";
            }
            case 88: {
                return ")";
            }
            case 110: {
                return "[";
            }
            case 111: {
                return "]";
            }
            case 113: {
                return "{";
            }
            case 114: {
                return "}";
            }
            case 87: {
                return ",";
            }
            case 83: {
                return ".";
            }
            case 96: {
                return "&&";
            }
            case 95: {
                return "||";
            }
            case 115: {
                return defaultValue == null ? "misc" : defaultValue;
            }
            case -1: {
                return "<eof>";
            }
        }
        return tokenType > this.tokenNames.length ? "unknown" : this.tokenNames[tokenType];
    }
}

