/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.drools.compiler.Dialect;
import org.drools.compiler.RuleError;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Declaration;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.java.AbstractJavaBuilder;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.drools.rule.builder.dialect.java.parser.JavaModifyBlockDescr;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.PatternExtractor;
import org.mvel.ExecutableStatement;

public class JavaConsequenceBuilder
extends AbstractJavaBuilder
implements ConsequenceBuilder {
    public void build(RuleBuildContext context) {
        context.getBuildStack().push(context.getRule().getLhs());
        String className = "consequence";
        RuleDescr ruleDescr = context.getRuleDescr();
        Dialect.AnalysisResult analysis = context.getDialect().analyzeBlock(context, ruleDescr, (String)ruleDescr.getConsequence());
        if (analysis == null) {
            return;
        }
        String fixedConsequence = this.fixModifyBlocks(context, (JavaAnalysisResult)analysis, (String)ruleDescr.getConsequence());
        if (fixedConsequence == null) {
            return;
        }
        fixedConsequence = ((JavaDialect)context.getDialect()).getKnowledgeHelperFixer().fix(fixedConsequence);
        List[] usedIdentifiers = analysis.getBoundIdentifiers();
        Declaration[] declarations = new Declaration[usedIdentifiers[0].size()];
        int size = usedIdentifiers[0].size();
        for (int i = 0; i < size; ++i) {
            declarations[i] = context.getDeclarationResolver().getDeclaration((String)usedIdentifiers[0].get(i));
        }
        Map map = this.createVariableContext("consequence", null, context, declarations, null, usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]));
        map.put("text", fixedConsequence);
        List<Declaration> list = Arrays.asList(context.getRule().getDeclarations());
        Integer[] indexes = new Integer[declarations.length];
        Boolean[] notPatterns = new Boolean[declarations.length];
        int length = declarations.length;
        for (int i = 0; i < length; ++i) {
            indexes[i] = new Integer(list.indexOf(declarations[i]));
            Boolean bl = notPatterns[i] = declarations[i].getExtractor() instanceof PatternExtractor ? new Boolean(false) : new Boolean(true);
            if (indexes[i] != -1) continue;
            context.getErrors().add(new RuleError(context.getRule(), ruleDescr, null, "Internal Error : Unable to find declaration in list while generating the consequence invoker"));
        }
        map.put("indexes", indexes);
        map.put("notPatterns", notPatterns);
        this.generatTemplates("consequenceMethod", "consequenceInvoker", context, "consequence", map, context.getRule(), ruleDescr);
        context.getBuildStack().pop();
    }

    protected String fixModifyBlocks(RuleBuildContext context, JavaAnalysisResult analysis, String originalCode) {
        MVELDialect mvel = (MVELDialect)context.getDialect("mvel");
        TreeSet blocks = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                JavaModifyBlockDescr d1 = (JavaModifyBlockDescr)o1;
                JavaModifyBlockDescr d2 = (JavaModifyBlockDescr)o2;
                return d1.getStart() - d2.getStart();
            }
        });
        Iterator it = analysis.getModifyBlocks().iterator();
        while (it.hasNext()) {
            blocks.add(it.next());
        }
        StringBuffer consequence = new StringBuffer();
        int lastAdded = 0;
        Iterator it2 = blocks.iterator();
        while (it2.hasNext()) {
            JavaModifyBlockDescr d = (JavaModifyBlockDescr)it2.next();
            consequence.append(originalCode.substring(lastAdded, d.getStart() - 1));
            lastAdded = d.getEnd();
            Dialect.AnalysisResult mvelAnalysis = mvel.analyzeBlock(context, context.getRuleDescr(), mvel.getInterceptors(), d.getModifyExpression(), null);
            ExecutableStatement expr = (ExecutableStatement)mvel.compile(d.getModifyExpression(), mvelAnalysis, mvel.getInterceptors(), null, null, context);
            Class ret = expr.getKnownEgressType();
            if (ret == null) {
                context.getErrors().add(new RuleError(context.getRule(), context.getRuleDescr(), originalCode, "Unable to determine the resulting type of the expression: " + d.getModifyExpression() + "\n"));
                return null;
            }
            consequence.append("{\n");
            consequence.append(ret.getName());
            consequence.append(" __obj__ = (");
            consequence.append(ret.getName());
            consequence.append(") ");
            consequence.append(d.getModifyExpression());
            consequence.append(";\n");
            consequence.append("modifyRetract( __obj__ );\n");
            Iterator exprIt = d.getExpressions().iterator();
            while (exprIt.hasNext()) {
                consequence.append("__obj__.");
                consequence.append(exprIt.next());
                consequence.append(";\n");
            }
            consequence.append("modifyInsert( __obj__ );");
            consequence.append("}\n");
        }
        consequence.append(originalCode.substring(lastAdded));
        return consequence.toString();
    }
}

