/*
 * Decompiled with CFR 0.152.
 */
package org.drools.brms.client.modeldriven;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.brms.client.modeldriven.brl.ActionFieldValue;
import org.drools.brms.client.modeldriven.brl.DSLSentence;
import org.drools.brms.client.modeldriven.brl.FactPattern;
import org.drools.brms.client.modeldriven.brl.FieldConstraint;
import org.drools.brms.client.modeldriven.brl.PortableObject;
import org.drools.brms.client.modeldriven.brl.SingleFieldConstraint;

public class SuggestionCompletionEngine
implements PortableObject {
    public static final String TYPE_COLLECTION = "Collection";
    public static final String TYPE_COMPARABLE = "Comparable";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_NUMERIC = "Numeric";
    public static final String TYPE_BOOLEAN = "Boolean";
    public static final String TYPE_OBJECT = "Object";
    private static final String[] STANDARD_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !="};
    private static final String[] STRING_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "&& matches", "|| matches"};
    private static final String[] COMPARABLE_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "&& >", "&& <", "|| >", "|| <", "&& >=", "&& <=", "|| <=", "|| >="};
    private static final String[] COLLECTION_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "|| contains", "&& contains", "|| excludes", "&& excludes"};
    private static final String[] STANDARD_OPERATORS = new String[]{"==", "!="};
    private static final String[] COMPARABLE_OPERATORS = new String[]{"==", "!=", "<", ">", "<=", ">="};
    private static final String[] STRING_OPERATORS = new String[]{"==", "!=", "matches", "soundslike"};
    private static final String[] COLLECTION_OPERATORS = new String[]{"contains", "excludes", "==", "!="};
    private static final String[] CONDITIONAL_ELEMENTS = new String[]{"not", "exists", "or"};
    public String[] factTypes;
    public Map fieldsForType;
    public Map fieldTypes;
    public Map globalTypes = new HashMap();
    public Map dataEnumLists = new HashMap();
    public DSLSentence[] conditionDSLSentences = new DSLSentence[0];
    public DSLSentence[] actionDSLSentences = new DSLSentence[0];
    private transient Map dataEnumLookupFields;

    public String[] getConditionalElements() {
        return CONDITIONAL_ELEMENTS;
    }

    public DSLSentence[] getDSLConditions() {
        return this.conditionDSLSentences;
    }

    public DSLSentence[] getDSLActions() {
        return this.actionDSLSentences;
    }

    public String[] getConnectiveOperatorCompletions(String factType, String fieldName) {
        String type = (String)this.fieldTypes.get(factType + "." + fieldName);
        if (type == null) {
            return STANDARD_CONNECTIVES;
        }
        if (type.equals(TYPE_STRING)) {
            return STRING_CONNECTIVES;
        }
        if (type.equals(TYPE_COMPARABLE) || type.equals(TYPE_NUMERIC)) {
            return COMPARABLE_CONNECTIVES;
        }
        if (type.equals(TYPE_COLLECTION)) {
            return COLLECTION_CONNECTIVES;
        }
        return STANDARD_CONNECTIVES;
    }

    public String[] getFactTypes() {
        return this.factTypes;
    }

    public String[] getFieldCompletions(String factType) {
        return (String[])this.fieldsForType.get(factType);
    }

    public String[] getOperatorCompletions(String factType, String fieldName) {
        String type = (String)this.fieldTypes.get(factType + "." + fieldName);
        if (type == null) {
            return STANDARD_OPERATORS;
        }
        if (type.equals(TYPE_STRING)) {
            return STRING_OPERATORS;
        }
        if (type.equals(TYPE_COMPARABLE) || type.equals(TYPE_NUMERIC)) {
            return COMPARABLE_OPERATORS;
        }
        if (type.equals(TYPE_COLLECTION)) {
            return COLLECTION_OPERATORS;
        }
        return STANDARD_OPERATORS;
    }

    public String getFieldType(String factType, String fieldName) {
        return (String)this.fieldTypes.get(factType + "." + fieldName);
    }

    public boolean isGlobalVariable(String variable) {
        return this.globalTypes.containsKey(variable);
    }

    public String[] getFieldCompletionsForGlobalVariable(String varName) {
        String type = (String)this.globalTypes.get(varName);
        return (String[])this.fieldsForType.get(type);
    }

    private String[] toStringArray(Set set) {
        String[] f = new String[set.size()];
        int i = 0;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            f[i] = (String)iter.next();
            ++i;
        }
        return f;
    }

    public String[] getGlobalVariables() {
        return this.toStringArray(this.globalTypes.keySet());
    }

    public String[] getEnums(FactPattern pat, String field) {
        Map dataEnumLookupFields = this.loadDataEnumLookupFields();
        String typeField = (String)dataEnumLookupFields.get(pat.factType + "." + field);
        if (pat.constraintList != null && pat.constraintList.constraints != null) {
            FieldConstraint[] cons = pat.constraintList.constraints;
            for (int i = 0; i < cons.length; ++i) {
                FieldConstraint con = cons[i];
                if (!(con instanceof SingleFieldConstraint)) continue;
                SingleFieldConstraint sfc = (SingleFieldConstraint)con;
                if (!sfc.fieldName.equals(typeField)) continue;
                String key = pat.factType + "." + field + "[" + typeField + "=" + sfc.value + "]";
                return (String[])this.dataEnumLists.get(key);
            }
        }
        return (String[])this.dataEnumLists.get(pat.factType + "." + field);
    }

    public String[] getEnums(String type, ActionFieldValue[] currentValues, String field) {
        Map dataEnumLookupFields = this.loadDataEnumLookupFields();
        String typeField = (String)dataEnumLookupFields.get(type + "." + field);
        if (currentValues != null) {
            for (int i = 0; i < currentValues.length; ++i) {
                ActionFieldValue val = currentValues[i];
                if (!val.field.equals(typeField)) continue;
                String key = type + "." + field + "[" + typeField + "=" + val.value + "]";
                return (String[])this.dataEnumLists.get(key);
            }
        }
        return (String[])this.dataEnumLists.get(type + "." + field);
    }

    private Map loadDataEnumLookupFields() {
        if (this.dataEnumLookupFields == null) {
            this.dataEnumLookupFields = new HashMap();
            Set keys = this.dataEnumLists.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (key.indexOf(91) == -1) continue;
                int ix = key.indexOf(91);
                String factField = key.substring(0, ix);
                String predicate = key.substring(ix + 1, key.indexOf(93));
                String typeField = predicate.substring(0, predicate.indexOf(61));
                this.dataEnumLookupFields.put(factField, typeField);
            }
        }
        return this.dataEnumLookupFields;
    }
}

