/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.drools.model.Prototype;
import org.drools.model.PrototypeFact;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Function3;

public interface PrototypeExpression {
    public Function1<PrototypeFact, Object> asFunction(Prototype var1);

    public Collection<String> getImpactedFields();

    public static PrototypeExpression fixedValue(Object value) {
        return new FixedValue(value);
    }

    public static PrototypeExpression prototypeField(String fieldName) {
        return new PrototypeFieldValue(fieldName);
    }

    default public PrototypeExpression composeWith(BinaryOperation.Operator op, PrototypeExpression right) {
        return new BinaryOperation(this, op, right);
    }

    default public PrototypeExpression add(PrototypeExpression right) {
        return this.composeWith(BinaryOperation.Operator.ADD, right);
    }

    default public PrototypeExpression sub(PrototypeExpression right) {
        return this.composeWith(BinaryOperation.Operator.SUB, right);
    }

    default public PrototypeExpression mul(PrototypeExpression right) {
        return this.composeWith(BinaryOperation.Operator.MUL, right);
    }

    default public PrototypeExpression div(PrototypeExpression right) {
        return this.composeWith(BinaryOperation.Operator.DIV, right);
    }

    public static class BinaryOperation
    implements PrototypeExpression {
        private final PrototypeExpression left;
        private final Operator op;
        private final PrototypeExpression right;

        private BinaryOperation(PrototypeExpression left, Operator op, PrototypeExpression right) {
            this.left = left;
            this.op = op;
            this.right = right;
        }

        @Override
        public Function1<PrototypeFact, Object> asFunction(Prototype prototype) {
            return this.op.operator.apply(prototype, this.left, this.right);
        }

        public String toString() {
            return this.left + " " + this.op + " " + this.right;
        }

        @Override
        public Collection<String> getImpactedFields() {
            HashSet<String> fields = new HashSet<String>();
            fields.addAll(this.left.getImpactedFields());
            fields.addAll(this.right.getImpactedFields());
            return fields;
        }

        public static enum Operator {
            ADD("+", "add", Operator::add),
            SUB("-", "sub", Operator::sub),
            MUL("*", "mul", Operator::mul),
            DIV("/", "add", Operator::div);

            private final String symbol;
            private final String keyword;
            private final Function3<Prototype, PrototypeExpression, PrototypeExpression, Function1<PrototypeFact, Object>> operator;

            private Operator(String symbol, String keyword, Function3<Prototype, PrototypeExpression, PrototypeExpression, Function1<PrototypeFact, Object>> operator) {
                this.symbol = symbol;
                this.keyword = keyword;
                this.operator = operator;
            }

            private static Function1<PrototypeFact, Object> add(Prototype prototype, PrototypeExpression left, PrototypeExpression right) {
                return fact -> {
                    Object leftValue = left.asFunction(prototype).apply((PrototypeFact)fact);
                    Object rightValue = right.asFunction(prototype).apply((PrototypeFact)fact);
                    if (leftValue instanceof String) {
                        return (String)leftValue + (rightValue != null ? rightValue : "");
                    }
                    if (leftValue instanceof Integer && rightValue instanceof Integer) {
                        return (Integer)leftValue + (Integer)rightValue;
                    }
                    if (leftValue == null) {
                        return rightValue == null ? Integer.valueOf(0) : rightValue;
                    }
                    if (rightValue == null) {
                        return leftValue;
                    }
                    return ((Number)leftValue).doubleValue() + ((Number)rightValue).doubleValue();
                };
            }

            private static Function1<PrototypeFact, Object> sub(Prototype prototype, PrototypeExpression left, PrototypeExpression right) {
                return fact -> {
                    Object leftValue = left.asFunction(prototype).apply((PrototypeFact)fact);
                    Object rightValue = right.asFunction(prototype).apply((PrototypeFact)fact);
                    if (leftValue instanceof Integer && rightValue instanceof Integer) {
                        return (Integer)leftValue - (Integer)rightValue;
                    }
                    if (leftValue == null) {
                        return rightValue == null ? Integer.valueOf(0) : rightValue;
                    }
                    if (rightValue == null) {
                        return leftValue;
                    }
                    return ((Number)leftValue).doubleValue() - ((Number)rightValue).doubleValue();
                };
            }

            private static Function1<PrototypeFact, Object> mul(Prototype prototype, PrototypeExpression left, PrototypeExpression right) {
                return fact -> {
                    Object leftValue = left.asFunction(prototype).apply((PrototypeFact)fact);
                    Object rightValue = right.asFunction(prototype).apply((PrototypeFact)fact);
                    if (leftValue instanceof Integer && rightValue instanceof Integer) {
                        return (Integer)leftValue * (Integer)rightValue;
                    }
                    if (leftValue == null || rightValue == null) {
                        return 0;
                    }
                    return ((Number)leftValue).doubleValue() * ((Number)rightValue).doubleValue();
                };
            }

            private static Function1<PrototypeFact, Object> div(Prototype prototype, PrototypeExpression left, PrototypeExpression right) {
                return fact -> {
                    Object leftValue = left.asFunction(prototype).apply((PrototypeFact)fact);
                    Object rightValue = right.asFunction(prototype).apply((PrototypeFact)fact);
                    if (leftValue instanceof Integer && rightValue instanceof Integer) {
                        return (Integer)leftValue / (Integer)rightValue;
                    }
                    if (leftValue == null || rightValue == null) {
                        return 0;
                    }
                    return ((Number)leftValue).doubleValue() / ((Number)rightValue).doubleValue();
                };
            }

            public String toString() {
                return this.symbol;
            }

            public String getSymbol() {
                return this.symbol;
            }

            public String getKeyword() {
                return this.keyword;
            }

            public static Operator decodeSymbol(String symbol) {
                return Arrays.stream((Operator[])Operator.class.getEnumConstants()).filter(op -> op.getSymbol().equals(symbol)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unrecognized symbol: " + symbol));
            }

            public static Operator decodeKeyword(String keyword) {
                return Arrays.stream((Operator[])Operator.class.getEnumConstants()).filter(op -> op.getKeyword().equals(keyword)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unrecognized keyword: " + keyword));
            }
        }
    }

    public static class PrototypeFieldValue
    implements PrototypeExpression {
        private final String fieldName;

        PrototypeFieldValue(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public Function1<PrototypeFact, Object> asFunction(Prototype prototype) {
            return prototype.getFieldValueExtractor(this.fieldName)::apply;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String toString() {
            return "PrototypeFieldValue{" + this.fieldName + "}";
        }

        @Override
        public Collection<String> getImpactedFields() {
            return Collections.singletonList(this.fieldName);
        }
    }

    public static class FixedValue
    implements PrototypeExpression {
        private final Object value;

        FixedValue(Object value) {
            this.value = value;
        }

        @Override
        public Function1<PrototypeFact, Object> asFunction(Prototype prototype) {
            return x -> this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "FixedValue{" + this.value + "}";
        }

        @Override
        public Collection<String> getImpactedFields() {
            return Collections.emptyList();
        }
    }
}

