/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.spring.utils;

import java.util.Objects;
import org.dromara.hmily.common.utils.AssertUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ConfigurableApplicationContext;

public enum SpringBeanUtils {
    INSTANCE;

    private ConfigurableApplicationContext cfgContext;

    public <T> T getBean(Class<T> type) {
        AssertUtils.notNull(type);
        try {
            return (T)this.cfgContext.getBean(type);
        }
        catch (BeansException e) {
            try {
                return this.getByName(type);
            }
            catch (BeansException ex) {
                return null;
            }
        }
    }

    public void registerBean(Class<?> type, Object object) {
        if (Objects.nonNull(this.cfgContext)) {
            this.cfgContext.getBeanFactory().registerSingleton(type.getSimpleName(), object);
        }
    }

    public void setCfgContext(ConfigurableApplicationContext cfgContext) {
        this.cfgContext = cfgContext;
    }

    private <T> T getByName(Class<T> type) {
        return (T)this.cfgContext.getBean(type.getSimpleName(), type);
    }
}

