/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.spring.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.dromara.hmily.annotation.Hmily;
import org.dromara.hmily.core.field.AnnotationField;
import org.dromara.hmily.core.field.DefaultAnnotationField;
import org.dromara.hmily.core.holder.SingletonHolder;
import org.dromara.hmily.spi.ExtensionLoaderFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class RefererAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    private static AnnotationField annotationField = (AnnotationField)Optional.ofNullable(ExtensionLoaderFactory.load(AnnotationField.class)).orElse(new DefaultAnnotationField());

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Field[] fields;
        Class clazz = bean.getClass();
        if (this.isProxyBean(bean)) {
            clazz = AopUtils.getTargetClass((Object)bean);
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            try {
                if (!annotationField.check(field)) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                Object ref = field.get(bean);
                Class<?> refClass = field.getType();
                Method[] methods = refClass.getMethods();
                boolean anyMatch = Stream.of(methods).anyMatch(method -> Objects.nonNull(method.getAnnotation(Hmily.class)));
                if (!anyMatch) continue;
                SingletonHolder.INST.register(field.getType(), ref);
            }
            catch (Exception e) {
                throw new BeanInitializationException("Failed to init spring bean at filed " + field.getName() + " in class " + bean.getClass().getName(), (Throwable)e);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private boolean isProxyBean(Object bean) {
        return AopUtils.isAopProxy((Object)bean);
    }
}

