/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.metrics.facade;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.dromara.hmily.config.api.entity.HmilyMetricsConfig;
import org.dromara.hmily.metrics.facade.handler.MetricsTrackerHandler;
import org.dromara.hmily.metrics.spi.MetricsInit;
import org.dromara.hmily.metrics.spi.MetricsTrackerManager;
import org.dromara.hmily.spi.ExtensionLoaderFactory;
import org.dromara.hmily.spi.HmilySPI;

@HmilySPI(value="metricsInit")
public class MetricsInitFacade
implements MetricsInit {
    private static volatile boolean enabled;
    private static MetricsTrackerManager metricsTrackerManager;

    public static boolean getEnabled() {
        return enabled;
    }

    public void init(HmilyMetricsConfig metricsConfig) {
        if (!enabled) {
            MetricsInitFacade.doInit(metricsConfig);
        }
    }

    public void close() {
        if (!enabled) {
            return;
        }
        if (null != metricsTrackerManager) {
            metricsTrackerManager.stop();
        }
        MetricsTrackerHandler.getInstance().close();
        enabled = false;
    }

    private static void doInit(HmilyMetricsConfig metricsConfig) {
        Preconditions.checkNotNull((Object)metricsConfig, (Object)"metrics configuration can not be null.");
        metricsTrackerManager = (MetricsTrackerManager)ExtensionLoaderFactory.load(MetricsTrackerManager.class, (String)metricsConfig.getMetricsName());
        Preconditions.checkNotNull((Object)metricsTrackerManager, (Object)"Can not find metrics tracker manager with metrics name in metrics configuration.");
        metricsTrackerManager.start(metricsConfig);
        Integer threadCount = Optional.ofNullable(metricsConfig.getThreadCount()).orElse(Runtime.getRuntime().availableProcessors());
        MetricsTrackerHandler.getInstance().init(metricsConfig.isAsync(), threadCount, metricsTrackerManager);
        enabled = true;
    }
}

