/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPath;
import org.docx4j.XmlUtils;
import org.docx4j.docProps.core.CoreProperties;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.jaxb.NamespacePrefixMappings;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.utils.XPathFactoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class DocPropsCorePart
extends JaxbXmlPart<CoreProperties> {
    private static Logger log = LoggerFactory.getLogger(DocPropsCorePart.class);
    private static XPath xPath = XPathFactoryUtil.newXPath();
    private NamespacePrefixMappings nsContext;

    public DocPropsCorePart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public DocPropsCorePart() throws InvalidFormatException {
        super(new PartName("/docProps/core.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-package.core-properties+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties");
        this.setJAXBContext(Context.jcDocPropsCore);
    }

    @Override
    public CoreProperties unmarshal(InputStream is) throws JAXBException {
        try {
            XMLInputFactory xif = XMLInputFactory.newInstance();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xsr = xif.createXMLStreamReader(is);
            this.setJAXBContext(Context.jcDocPropsCore);
            Unmarshaller u = this.jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            log.info("unmarshalling " + this.getClass().getName());
            this.jaxbElement = (CoreProperties)u.unmarshal(xsr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (CoreProperties)this.jaxbElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String xpathGetString(String xpathString, String prefixMappings) throws Docx4JException {
        Document doc = XmlUtils.marshaltoW3CDomDocument(this.getJaxbElement(), Context.jcDocPropsCore);
        try {
            String result;
            XPath xPath = DocPropsCorePart.xPath;
            synchronized (xPath) {
                this.getNamespaceContext();
                NamespacePrefixMappings.registerPrefixMappings(prefixMappings);
                result = DocPropsCorePart.xPath.evaluate(xpathString, doc);
            }
            log.debug(xpathString + " ---> " + result);
            return result;
        }
        catch (Exception e) {
            throw new Docx4JException("Problems evaluating xpath '" + xpathString + "'", e);
        }
    }

    private NamespacePrefixMappings getNamespaceContext() {
        if (this.nsContext == null) {
            this.nsContext = new NamespacePrefixMappings();
            xPath.setNamespaceContext(this.nsContext);
        }
        return this.nsContext;
    }
}

