/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts.autodetect;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.docx4j.fonts.fop.fonts.autodetect.FontDirFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsFontDirFinder
implements FontDirFinder {
    protected static Logger log = LoggerFactory.getLogger(WindowsFontDirFinder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWinDir(String osName) throws IOException {
        Process process = null;
        Runtime runtime = Runtime.getRuntime();
        process = osName.startsWith("Windows 9") ? runtime.exec("command.com /c echo %windir%") : runtime.exec("cmd.exe /c echo %windir%");
        InputStreamReader isr = null;
        BufferedReader bufferedReader = null;
        String dir = "";
        try {
            isr = new InputStreamReader(process.getInputStream());
            bufferedReader = new BufferedReader(isr);
            dir = bufferedReader.readLine();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            IOUtils.closeQuietly((Reader)isr);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        IOUtils.closeQuietly((Reader)isr);
        return dir;
    }

    @Override
    public List<File> find() {
        ArrayList<File> fontDirList;
        block19: {
            char driveLetter;
            File psFontsDir;
            File osFontsDir;
            String osName;
            block18: {
                fontDirList = new ArrayList<File>();
                String windir = null;
                try {
                    windir = System.getProperty("env.windir");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                osName = System.getProperty("os.name");
                if (windir == null) {
                    try {
                        windir = this.getWinDir(osName);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                osFontsDir = null;
                psFontsDir = null;
                if (windir == null) break block18;
                if (windir.endsWith("/")) {
                    windir = windir.substring(0, windir.length() - 1);
                }
                if ((osFontsDir = new File(windir + File.separator + "FONTS")).exists() && osFontsDir.canRead()) {
                    fontDirList.add(osFontsDir);
                }
                if (!(psFontsDir = new File(windir.substring(0, 2) + File.separator + "PSFONTS")).exists() || !psFontsDir.canRead()) break block19;
                fontDirList.add(psFontsDir);
                break block19;
            }
            String windowsDirName = osName.endsWith("NT") ? "WINNT" : "WINDOWS";
            for (driveLetter = 'C'; driveLetter <= 'E'; driveLetter = (char)(driveLetter + '\u0001')) {
                osFontsDir = new File(driveLetter + ":" + File.separator + windowsDirName + File.separator + "FONTS");
                if (!osFontsDir.exists() || !osFontsDir.canRead()) continue;
                fontDirList.add(osFontsDir);
                break;
            }
            for (driveLetter = 'C'; driveLetter <= 'E'; driveLetter = (char)(driveLetter + '\u0001')) {
                psFontsDir = new File(driveLetter + ":" + File.separator + "PSFONTS");
                if (!psFontsDir.exists() || !psFontsDir.canRead()) continue;
                fontDirList.add(psFontsDir);
                break;
            }
        }
        String localAppData = System.getenv("LOCALAPPDATA");
        File userFontsDir = null;
        if (localAppData == null) {
            log.debug("env missing LOCALAPPDATA");
        } else {
            userFontsDir = new File(localAppData + File.separator + "Microsoft" + File.separator + "Windows" + File.separator + "Fonts");
            if (userFontsDir.exists() && userFontsDir.canRead()) {
                fontDirList.add(userFontsDir);
                log.info("Adding: " + userFontsDir.getPath());
            } else {
                log.info("Missing or can't read: " + userFontsDir.getPath());
            }
        }
        if (userFontsDir == null) {
            String userHome = System.getProperty("user.home");
            if (userHome == null) {
                log.debug("null user.home");
            } else {
                userFontsDir = new File(userHome, "AppData" + File.separator + "Local" + File.separator + "Microsoft" + File.separator + "Windows" + File.separator + "Fonts");
                if (userFontsDir.exists() && userFontsDir.canRead()) {
                    fontDirList.add(userFontsDir);
                    log.info("Adding: " + userFontsDir.getPath());
                } else {
                    log.info("Missing or can't read: " + userFontsDir.getPath());
                }
            }
        }
        return fontDirList;
    }
}

