/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc.switches;

import jakarta.xml.bind.JAXBElement;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.docx4j.TraversalUtil;
import org.docx4j.finders.RangeFinder;
import org.docx4j.jaxb.Context;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.listnumbering.Emulator;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.toc.StyleBasedOnHelper;
import org.docx4j.toc.TocEntry;
import org.docx4j.toc.switches.CSwitch;
import org.docx4j.toc.switches.OSwitch;
import org.docx4j.toc.switches.SwitchInterface;
import org.docx4j.toc.switches.SwitchProcessorInterface;
import org.docx4j.toc.switches.USwitch;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.STTabTlc;
import org.docx4j.wml.Style;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchProcessor
implements SwitchProcessorInterface {
    private static Logger log = LoggerFactory.getLogger(SwitchProcessor.class);
    protected PropertyResolver propertyResolver;
    protected StyleBasedOnHelper styleBasedOnHelper;
    private PageDimensions pageDimensions;
    private static final String TOC_PREFIX = "_Toc";
    private static final int MILLION = 1000000;
    private TocEntry entry = null;
    private STTabTlc leader;
    private boolean selected = false;
    private boolean pageNumbers = true;
    private AtomicInteger bookmarkId = null;

    @Override
    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    @Override
    public StyleBasedOnHelper getStyleBasedOnHelper() {
        return this.styleBasedOnHelper;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public SwitchProcessor(PageDimensions pageDimensions, STTabTlc leader) {
        this.pageDimensions = pageDimensions;
        this.leader = leader;
    }

    public List<TocEntry> processSwitches(WordprocessingMLPackage wordMLPackage, List<P> pList, List<SwitchInterface> switchesList, Map<P, Emulator.ResultTriple> pNumbersMap) {
        ArrayList<TocEntry> tocEntries = new ArrayList<TocEntry>();
        this.propertyResolver = wordMLPackage.getMainDocumentPart().getPropertyResolver();
        this.styleBasedOnHelper = new StyleBasedOnHelper(this.propertyResolver);
        int randomSeed = (int)(Math.random() * 1000000.0);
        AtomicInteger seedIndex = this.getBookmarkId(wordMLPackage);
        Object anchorValue = "";
        for (P p : pList) {
            PPr ppr = p.getPPr();
            if (ppr == null) continue;
            PPrBase.PStyle pStyle = ppr.getPStyle();
            if (pStyle == null) {
                log.debug("P has no style; ignoring..");
                continue;
            }
            Style s = this.propertyResolver.getStyle(pStyle.getVal());
            log.debug("Processing switches for P with stylename " + pStyle.getVal());
            if (s == null) {
                log.warn("Style " + pStyle.getVal() + " is not defined in styles part!");
                continue;
            }
            OSwitch oSwitch = null;
            for (SwitchInterface sw : switchesList) {
                if (!(sw instanceof OSwitch)) continue;
                oSwitch = (OSwitch)sw;
            }
            for (SwitchInterface sw : switchesList) {
                log.debug(sw.getClass().getName());
                if (sw instanceof CSwitch) {
                    ((CSwitch)sw).process(p, (SwitchProcessorInterface)this);
                    if (!((CSwitch)sw).isDetected()) continue;
                    p = ((CSwitch)sw).postprocess(p, wordMLPackage);
                    continue;
                }
                if (sw instanceof USwitch) {
                    ((USwitch)sw).process(s, this, ppr, oSwitch);
                    continue;
                }
                sw.process(s, this);
            }
            if (this.selected) {
                this.entry.setEntryValue(p);
                this.entry.numberEntry(pNumbersMap.get(p));
                if (this.entry.getEntryValue() == null || this.entry.getEntryValue().size() == 0) {
                    log.debug("Not adding p to toc since it is empty.  (stylename " + pStyle.getVal());
                } else {
                    log.debug("Adding p to toc with stylename " + pStyle.getVal());
                    anchorValue = TOC_PREFIX + randomSeed + seedIndex;
                    this.bookmarkStyleText(p, (String)anchorValue, seedIndex, this.entry);
                    this.entry.setAnchorValue((String)anchorValue);
                    tocEntries.add(this.entry);
                }
            }
            this.entry = null;
            this.selected = false;
        }
        return tocEntries;
    }

    private void bookmarkStyleText(P p, String anchorValue, AtomicInteger id, TocEntry te) {
        CTBookmark bookmark = null;
        for (Object o : p.getContent()) {
            if (!(o instanceof CTBookmark)) continue;
            bookmark = (CTBookmark)o;
            break;
        }
        if (bookmark == null) {
            this.bookmarkP(p, anchorValue, id.getAndIncrement());
        } else {
            bookmark.setId(BigInteger.valueOf(id.getAndIncrement()));
            bookmark.setName(anchorValue);
        }
    }

    public void bookmarkP(P p, String name, int id) {
        ObjectFactory factory = Context.getWmlObjectFactory();
        BigInteger ID = BigInteger.valueOf(id);
        CTMarkupRange mr = factory.createCTMarkupRange();
        mr.setId(ID);
        JAXBElement bmEnd = factory.createBodyBookmarkEnd(mr);
        p.getContent().add(bmEnd);
        CTBookmark bm = factory.createCTBookmark();
        bm.setId(ID);
        bm.setName(name);
        JAXBElement bmStart = factory.createBodyBookmarkStart(bm);
        p.getContent().add(0, bmStart);
    }

    @Override
    public void setPageNumbers(boolean pageNumbers) {
        this.pageNumbers = pageNumbers;
    }

    public boolean pageNumbers() {
        return this.pageNumbers;
    }

    @Override
    public TocEntry getEntry() {
        if (this.entry == null) {
            this.entry = new TocEntry(this.propertyResolver, this.pageDimensions, this.leader);
        }
        return this.entry;
    }

    public void setStartingIdForNewBookmarks(AtomicInteger bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    protected AtomicInteger getBookmarkId(WordprocessingMLPackage wordMLPackage) {
        if (this.bookmarkId == null) {
            this.bookmarkId = new AtomicInteger(this.initBookmarkIdStart(wordMLPackage));
        }
        return this.bookmarkId;
    }

    private int initBookmarkIdStart(WordprocessingMLPackage wordMLPackage) {
        int highestId = 0;
        RangeFinder rt = new RangeFinder();
        new TraversalUtil(wordMLPackage.getMainDocumentPart().getContent(), rt);
        for (CTBookmark bm : rt.getStarts()) {
            BigInteger id = bm.getId();
            if (id == null || id.intValue() <= highestId) continue;
            highestId = id.intValue();
        }
        return highestId + 1;
    }
}

