/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.styles;

import java.util.ArrayList;
import java.util.List;
import org.docx4j.model.styles.Tree;

public class Node<T> {
    protected String styleId;
    protected Tree<T> tree;
    public T data;
    public List<Node<T>> children;
    private Node<T> parent;

    public Node<T> getParent() {
        return this.parent;
    }

    public void setParent(Node<T> parent) {
        this.parent = parent;
    }

    public Node(Tree<T> tree, String styleId, T data) {
        this.styleId = styleId;
        this.setData(data);
        this.tree = tree;
    }

    public List<Node<T>> getChildren() {
        if (this.children == null) {
            return new ArrayList<Node<T>>();
        }
        return this.children;
    }

    public void addChild(Node<T> child) {
        if (this.children == null) {
            this.children = new ArrayList<Node<T>>();
        }
        if (!this.children.contains(child)) {
            this.children.add(child);
            this.tree.nodes.put(child.styleId, child);
            child.setParent(this);
        }
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this.getData().toString()).append(",[");
        int i = 0;
        for (Node<T> e : this.getChildren()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(e.getData().toString());
            ++i;
        }
        sb.append("]").append("}");
        return sb.toString();
    }
}

