/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import javax.xml.transform.TransformerException;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.Writer;
import org.docx4j.convert.out.common.writer.AbstractSymbolWriter;
import org.docx4j.convert.out.common.writer.SymbolMapper;
import org.docx4j.convert.out.common.writer.SymbolUtils;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.wml.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SymbolWriter
extends AbstractSymbolWriter {
    private static final Logger log = LoggerFactory.getLogger(SymbolWriter.class);

    @Override
    public Node toNode(AbstractWmlConversionContext context, Object unmarshalledNode, Node modelContent, Writer.TransformState state, Document doc) throws TransformerException {
        R.Sym modelData = (R.Sym)unmarshalledNode;
        String value = modelData.getChar();
        byte[] valBytes = SymbolUtils.hexStringToByteArray(value);
        assert (valBytes.length <= 2);
        String fontName = modelData.getFont();
        String valStr = SymbolWriter.getReplacement(valBytes, fontName);
        Text theChar = doc.createTextNode(valStr);
        DocumentFragment docfrag = doc.createDocumentFragment();
        if (!valStr.equals("\u25a1")) {
            Element span = doc.createElement("span");
            docfrag.appendChild(span);
            span.setAttribute("style", "font-family: 'Arial, Helvetica, sans-serif'");
            span.appendChild(theChar);
        } else {
            PhysicalFont pf;
            if (log.isDebugEnabled()) {
                log.debug("No Unicode replacement for ? in font " + fontName);
            }
            if ((pf = context.getWmlPackage().getFontMapper().get(fontName)) == null) {
                log.warn("No physical font present for:" + fontName);
                docfrag.appendChild(theChar);
            } else {
                Element span = doc.createElement("span");
                docfrag.appendChild(span);
                span.setAttribute("style", "font-family: '" + pf.getName() + "'");
                span.appendChild(theChar);
            }
        }
        return docfrag;
    }

    public static String getReplacement(byte[] valBytes, String fontName) {
        String valStr;
        if (valBytes.length == 2 && 61440 <= SymbolUtils.short2Int(valBytes) && 65535 >= SymbolUtils.short2Int(valBytes)) {
            log.debug("In the Private Use Area");
            valBytes[0] = (byte)(valBytes[0] - 240);
            int nonZeroIdx = -1;
            for (int i = 0; i < valBytes.length; ++i) {
                if (valBytes[i] == 0) continue;
                nonZeroIdx = i;
                break;
            }
            if (nonZeroIdx != -1) {
                valStr = SymbolMapper.getUnicodeReplacementChar(fontName, (short)SymbolUtils.short2Int(valBytes));
                if (valStr == null) {
                    valStr = "\u25a1";
                    log.debug("Missing symbol.");
                } else if (log.isDebugEnabled()) {
                    log.debug("Got " + valStr);
                }
            } else {
                valStr = "\u25a1";
            }
        } else {
            log.debug("Not in Private Use Area");
            int codePoint = SymbolUtils.short2Int(valBytes);
            valStr = Character.toString(codePoint);
        }
        return valStr;
    }
}

