/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out;

import java.io.File;
import org.docx4j.convert.out.AbstractConversionSettings;
import org.docx4j.convert.out.ConversionFeatures;
import org.docx4j.convert.out.FORenderer;
import org.docx4j.convert.out.fopconf.Fop;
import org.docx4j.fonts.fop.util.FopConfigUtil;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FOSettings
extends AbstractConversionSettings {
    protected static Logger log = LoggerFactory.getLogger(FOSettings.class);
    public static final String INTERNAL_FO_MIME = "application/xml-fo";
    public static final String MIME_PDF = "application/pdf";
    public static final String APACHEFOP_CONFIGURATION = "apacheFopConfiguration";
    public static final String APACHEFOP_MIME = "apacheFopMime";
    public static final String CUSTOM_FO_RENDERER = "customFoRenderer";
    private static final String FO_DUMP_FILE = "foDumpFile";
    private Fop fopConfig;
    private boolean layoutMasterSetCalculationInProgress = false;

    public void setFopConfig(Fop fopConfig) {
        this.fopConfig = fopConfig;
    }

    public Fop getFopConfig() {
        return this.fopConfig;
    }

    public FOSettings() {
        this.addFeatures(ConversionFeatures.DEFAULT_PDF_FEATURES);
    }

    public FOSettings(OpcPackage opcPackage) throws Docx4JException {
        this.addFeatures(ConversionFeatures.DEFAULT_PDF_FEATURES);
        this.setOpcPackage(opcPackage);
    }

    @Override
    public void setOpcPackage(OpcPackage opcPackage) throws Docx4JException {
        this.settings.put("opcPackage", opcPackage);
        if (this.fopConfig == null && opcPackage instanceof WordprocessingMLPackage) {
            WordprocessingMLPackage wmlPackage = (WordprocessingMLPackage)opcPackage;
            this.fopConfig = FopConfigUtil.createConfigurationObject(wmlPackage.getFontMapper(), wmlPackage.getMainDocumentPart().fontsInUse());
        }
    }

    public String getApacheFopMime() {
        return (String)this.settings.get(APACHEFOP_MIME);
    }

    public void setApacheFopMime(String apacheFopMime) {
        this.settings.put(APACHEFOP_MIME, apacheFopMime);
    }

    public FORenderer getCustomFoRenderer() {
        return (FORenderer)this.settings.get(CUSTOM_FO_RENDERER);
    }

    public void setCustomFoRenderer(FORenderer customFoRenderer) {
        this.settings.put(CUSTOM_FO_RENDERER, customFoRenderer);
    }

    public File getFoDumpFile() {
        return (File)this.settings.get(FO_DUMP_FILE);
    }

    public void setFoDumpFile(File foFile) {
        this.settings.put(FO_DUMP_FILE, foFile);
    }

    public boolean lsLayoutMasterSetCalculationInProgress() {
        return this.layoutMasterSetCalculationInProgress;
    }

    public void setLayoutMasterSetCalculationInProgress(boolean layoutMasterSetCalculationInProgress) {
        this.layoutMasterSetCalculationInProgress = layoutMasterSetCalculationInProgress;
    }
}

