/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.util.JAXBResult;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stax.StAXSource;
import org.apache.commons.io.IOUtils;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.Docx4jMarshallerListener;
import org.docx4j.jaxb.Docx4jUnmarshallerListener;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.jaxb.McIgnorableNamespaceDeclarator;
import org.docx4j.jaxb.NamespacePrefixMapperUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.LocationAwareXMLStreamException;
import org.docx4j.openpackaging.exceptions.PartTooLargeException;
import org.docx4j.openpackaging.io3.stores.PartStore;
import org.docx4j.openpackaging.io3.stores.ZipPartStore;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.SAXHandler;
import org.docx4j.openpackaging.parts.StAXHandlerInterface;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPartFilterOutputStream;
import org.docx4j.org.apache.poi.util.XMLHelper;
import org.docx4j.org.apache.xml.security.Init;
import org.docx4j.org.apache.xml.security.c14n.Canonicalizer;
import org.docx4j.utils.StaXInputFactoryUtils;
import org.docx4j.utils.XMLStreamWriterWrapper;
import org.docx4j.utils.XMLStreamWriterWrapperIndenting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class JaxbXmlPart<E>
extends Part {
    protected static Logger log = LoggerFactory.getLogger(JaxbXmlPart.class);
    protected JAXBContext jc;
    protected static long MAX_BYTES_Unmarshal_Error = -1L;
    protected E jaxbElement = null;
    private Set<String> mcChoiceNamespaces = new HashSet<String>();

    public JaxbXmlPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.setJAXBContext(Context.jc);
    }

    public JaxbXmlPart(PartName partName, JAXBContext jc) throws InvalidFormatException {
        super(partName);
        this.setJAXBContext(jc);
    }

    public void setJAXBContext(JAXBContext jc) {
        this.jc = jc;
    }

    public JAXBContext getJAXBContext() {
        return this.jc;
    }

    public E getContents() throws Docx4JException {
        InputStream is = null;
        if (this.jaxbElement == null) {
            block13: {
                if (this.getPackage() == null) {
                    log.warn("This part not added to a package, so its contents can't be retrieved. ");
                    return null;
                }
                PartStore partStore = this.getPackage().getSourcePartStore();
                if (partStore == null) {
                    log.info("No PartStore defined for this package (it was probably created, not loaded). ");
                    log.info(this.getPartName().getName() + ": did you initialise its contents to something?");
                    return null;
                }
                try {
                    String name = this.getPartName().getName();
                    try {
                        if (partStore != null) {
                            this.setContentLengthAsLoaded(partStore.getPartSize(name.substring(1)));
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                    if (MAX_BYTES_Unmarshal_Error > -1L && this.getContentLengthAsLoaded() > MAX_BYTES_Unmarshal_Error) {
                        throw new PartTooLargeException(this.getPartName() + ", length " + this.getContentLengthAsLoaded() + " exceeds your configured maximum allowed size for unmarshal.");
                    }
                    is = partStore.loadPart(name.substring(1));
                    if (is == null) {
                        log.warn(name + " missing from part store");
                        break block13;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Lazily unmarshalling " + name);
                    }
                    this.unmarshal(is);
                }
                catch (JAXBException e) {
                    try {
                        throw new Docx4JException("Problem with part " + this.getPartName(), (Exception)((Object)e));
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        return this.jaxbElement;
    }

    public E getJaxbElement() {
        try {
            return this.getContents();
        }
        catch (Docx4JException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setJaxbElement(E jaxbElement) {
        this.jaxbElement = jaxbElement;
    }

    public void setContents(E jaxbElement) {
        this.jaxbElement = jaxbElement;
    }

    public void setJaxbElement(JAXBResult result) throws JAXBException {
        this.setJaxbElement(result.getResult());
    }

    public String getXML() {
        return XmlUtils.marshaltoString(this.getJaxbElement(), true, true, this.jc, this.getMcChoiceNamespaces());
    }

    public boolean isUnmarshalled() {
        return this.jaxbElement != null;
    }

    public void variableReplace(Map<String, String> mappings) throws JAXBException, Docx4JException {
        String wmlTemplateString = null;
        if (this.jaxbElement == null) {
            String name;
            PartStore partStore = this.getPackage().getSourcePartStore();
            InputStream is = partStore.loadPart((name = this.getPartName().getName()).substring(1));
            if (is == null) {
                log.warn(name + " missing from part store");
                throw new Docx4JException(name + " missing from part store");
            }
            log.info("Lazily unmarshalling " + name);
            try {
                wmlTemplateString = IOUtils.toString((InputStream)is, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new Docx4JException(e.getMessage(), e);
            }
        } else {
            wmlTemplateString = XmlUtils.marshaltoString(this.jaxbElement, true, false, this.jc);
        }
        this.jaxbElement = XmlUtils.unwrap(XmlUtils.unmarshallFromTemplate(wmlTemplateString, mappings, this.jc));
    }

    public void transform(Templates xslt, Map<String, Object> transformParameters, Result result) throws Docx4JException {
        block13: {
            if (this.jaxbElement == null) {
                PartStore partStore = this.getPackage().getSourcePartStore();
                String name = this.getPartName().getName();
                try (InputStream is = partStore.loadPart(name.substring(1));){
                    if (is == null) {
                        log.warn(name + " missing from part store");
                        throw new Docx4JException(name + " missing from part store");
                    }
                    XMLInputFactory xif = XMLInputFactory.newInstance();
                    xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                    xif.setProperty("javax.xml.stream.supportDTD", false);
                    XMLStreamReader xsr = xif.createXMLStreamReader(is);
                    XmlUtils.transform(new StAXSource(xsr), xslt, transformParameters, result);
                    break block13;
                }
                catch (IOException e) {
                    throw new Docx4JException(e.getMessage(), e);
                }
                catch (XMLStreamException e) {
                    throw new Docx4JException(e.getMessage(), e);
                }
            }
            Document doc = XmlUtils.neww3cDomDocument();
            try {
                this.marshal(doc);
            }
            catch (JAXBException e) {
                throw new Docx4JException("Marshalling exception preparing content for transform", (Exception)((Object)e));
            }
            XmlUtils.transform(doc, xslt, transformParameters, result);
        }
    }

    public void pipe(SAXHandler saxHandler) throws ParserConfigurationException, SAXException, Docx4JException, IOException, JAXBException {
        XMLReader xmlReader = XMLHelper.newXMLReader();
        xmlReader.setContentHandler(saxHandler);
        PartStore partStore = null;
        if (this.jaxbElement == null) {
            String name;
            partStore = this.getPackage().getSourcePartStore();
            InputStream is = partStore.loadPart((name = this.getPartName().getName()).substring(1));
            if (is == null) {
                log.warn(name + " missing from part store");
                throw new Docx4JException(name + " missing from part store");
            }
            log.info("Fetching from part store " + name);
            xmlReader.parse(new InputSource(is));
        } else {
            xmlReader.parse(new InputSource(XmlUtils.marshaltoInputStream(this.jaxbElement, true, this.jc)));
        }
        this.replacePartContent(saxHandler.getOutputStream().toByteArray());
    }

    public void pipe(StAXHandlerInterface handler) throws XMLStreamException, Docx4JException, JAXBException {
        this.pipe(handler, null);
    }

    public void pipe(StAXHandlerInterface handler, StreamFilter filter) throws XMLStreamException, Docx4JException, JAXBException {
        XMLStreamReader xmlr = this.getXMLStreamReader(filter);
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlWriter = null;
        ByteArrayOutputStream baos = null;
        if (this.jaxbElement == null) {
            baos = new ByteArrayOutputStream();
            xmlWriter = outputFactory.createXMLStreamWriter(baos, "UTF-8");
        } else {
            baos = new ByteArrayOutputStream();
            xmlWriter = outputFactory.createXMLStreamWriter(baos, "UTF-8");
        }
        try {
            log.debug("StAX implementation details:");
            log.debug(xmlr.getClass().getName());
            log.debug(xmlWriter.getClass().getName());
            handler.handle(xmlr, xmlWriter);
        }
        catch (LocationAwareXMLStreamException e) {
            log.error(e.getMessage() + " at line " + e.getLocation().getLineNumber() + ", col " + e.getLocation().getColumnNumber());
            e.getCause().printStackTrace();
            InputStream is = null;
            if (this.jaxbElement == null) {
                String name;
                PartStore partStore = this.getPackage().getSourcePartStore();
                is = partStore.loadPart((name = this.getPartName().getName()).substring(1));
                if (is == null) {
                    log.warn(name + " missing from part store");
                    throw new Docx4JException(name + " missing from part store");
                }
            } else {
                is = XmlUtils.marshaltoInputStream(this.jaxbElement, true, this.jc);
            }
            if (is != null) {
                int end;
                List lines = IOUtils.readLines((InputStream)is);
                String line = (String)lines.get(e.getLocation().getLineNumber() - 1);
                int PRIOR_CHARS = 100;
                int start = 0;
                if (e.getLocation().getColumnNumber() > PRIOR_CHARS) {
                    start = e.getLocation().getColumnNumber() - PRIOR_CHARS;
                }
                if ((end = e.getLocation().getColumnNumber() + PRIOR_CHARS) > line.length() - 1) {
                    end = line.length() - 1;
                }
                log.error("error is at pos " + PRIOR_CHARS + " in " + line.substring(start, end));
            }
            throw (XMLStreamException)e.getCause();
        }
        xmlr.close();
        xmlWriter.flush();
        xmlWriter.close();
        this.replacePartContent(baos.toByteArray());
    }

    public XMLStreamReader getXMLStreamReader(StreamFilter filter) throws FactoryConfigurationError, Docx4JException, XMLStreamException {
        XMLInputFactory xmlif = null;
        xmlif = XMLInputFactory.newInstance();
        xmlif.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlif.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlif.setXMLReporter(new XMLReporter(){

            @Override
            public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
                log.warn("Error:" + errorType + ", " + message + " at line " + location.getLineNumber() + ", col " + location.getColumnNumber());
            }
        });
        XMLStreamReader xmlr = null;
        PartStore partStore = null;
        if (this.jaxbElement == null) {
            log.info("jaxbElement not unmarshalled yet");
            partStore = this.getPackage().getSourcePartStore();
            String name = this.getPartName().getName();
            InputStream is = partStore.loadPart(name.substring(1));
            if (is == null) {
                log.warn(name + " missing from part store");
                throw new Docx4JException(name + " missing from part store");
            }
            log.info("Fetching from part store " + name);
            xmlr = filter == null ? xmlif.createXMLStreamReader(is) : xmlif.createFilteredReader(xmlif.createXMLStreamReader(is), filter);
        } else {
            log.info("Existing jaxbElement..");
            xmlr = filter == null ? xmlif.createXMLStreamReader(XmlUtils.marshaltoInputStream(this.jaxbElement, true, this.jc)) : xmlif.createFilteredReader(xmlif.createXMLStreamReader(XmlUtils.marshaltoInputStream(this.jaxbElement, true, this.jc)), filter);
        }
        return xmlr;
    }

    public void replacePartContent(byte[] bytes) throws JAXBException, Docx4JException {
        if (this.jaxbElement != null) {
            this.jaxbElement = this.unmarshal(new ByteArrayInputStream(bytes));
            return;
        }
        PartStore partStore = this.getPackage().getSourcePartStore();
        if (partStore instanceof ZipPartStore) {
            log.debug("Just update the entry in the ZipPartStore");
            ZipPartStore.ByteArray byteArray = ((ZipPartStore)partStore).getByteArray(this.getPartName().getName().substring(1));
            byteArray.setBytes(bytes);
        } else {
            if (log.isInfoEnabled()) {
                log.info(partStore.getClass().getName() + ": can't update in place, so unmarshalling.");
            }
            this.jaxbElement = this.unmarshal(new ByteArrayInputStream(bytes));
        }
    }

    public void marshal(Node node) throws JAXBException {
        this.marshal(node, NamespacePrefixMapperUtils.getPrefixMapper());
    }

    public void marshal(Node node, Object namespacePrefixMapper) throws JAXBException {
        try {
            Marshaller marshaller = this.jc.createMarshaller();
            NamespacePrefixMapperUtils.setProperty(marshaller, namespacePrefixMapper);
            this.getContents();
            this.setMceIgnorable((McIgnorableNamespaceDeclarator)namespacePrefixMapper);
            marshaller.marshal(this.jaxbElement, node);
            ((McIgnorableNamespaceDeclarator)namespacePrefixMapper).setMcIgnorable(null);
        }
        catch (Docx4JException e) {
            throw new JAXBException((Throwable)e);
        }
    }

    public void marshal(OutputStream os) throws JAXBException {
        this.marshal(os, NamespacePrefixMapperUtils.getPrefixMapper());
    }

    public void marshal(OutputStream os, Object namespacePrefixMapper) throws JAXBException {
        try {
            Marshaller marshaller = this.jc.createMarshaller();
            if (Docx4jProperties.getProperty("docx4j.jaxb.formatted.output", true)) {
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
            }
            NamespacePrefixMapperUtils.setProperty(marshaller, namespacePrefixMapper);
            log.debug("marshalling " + this.getClass().getName());
            this.getContents();
            this.setMceIgnorable((McIgnorableNamespaceDeclarator)namespacePrefixMapper);
            String mceIgnorable = "";
            if (this.getMceIgnorable() != null) {
                mceIgnorable = this.getMceIgnorable();
            }
            if (Docx4jProperties.getProperty("docx4j.jaxb.marshal.canonicalize", false)) {
                Document doc = XmlUtils.marshaltoW3CDomDocument(this.jaxbElement, this.jc);
                NamespacePrefixMapperUtils.declareNamespaces(mceIgnorable + this.getMcChoiceNamespaces(), doc);
                log.debug("Input to Canonicalizer: " + XmlUtils.w3CDomNodeToString(doc));
                Init.init();
                Canonicalizer c = Canonicalizer.getInstance("http://www.w3.org/2001/10/xml-exc-c14n#");
                log.debug("canonicalizeSubtree with inclusiveNamespaces {}, {}", (Object)this.getMceIgnorable(), (Object)this.getMcChoiceNamespaces());
                byte[] bytes = c.canonicalizeSubtree(doc, this.getMceIgnorable() + this.getMcChoiceNamespaces());
                IOUtils.write((byte[])bytes, (OutputStream)os);
            } else if (!Docx4jProperties.getProperty("docx4j.openpackaging.parts.JaxbXmlPart.MarshalToOutputStreamViaXMLStreamWriter", false)) {
                log.debug("Marshalling to " + os.getClass().getName());
                ((McIgnorableNamespaceDeclarator)namespacePrefixMapper).setMcIgnorable(mceIgnorable + this.getMcChoiceNamespaces());
                if (this instanceof MainDocumentPart) {
                    BufferedOutputStream buffered = new BufferedOutputStream(os);
                    boolean isNew = this.getPackage() == null ? true : this.getPackage().isNew();
                    MainDocumentPartFilterOutputStream filteredOS = new MainDocumentPartFilterOutputStream(buffered, isNew);
                    marshaller.marshal(this.jaxbElement, (OutputStream)filteredOS);
                    buffered.flush();
                } else {
                    marshaller.marshal(this.jaxbElement, os);
                }
            } else {
                log.debug("MarshalToOutputStreamViaXMLStreamWriter set; " + os.getClass().getName());
                XMLOutputFactory xof = XMLOutputFactory.newFactory();
                XMLStreamWriter xsw = xof.createXMLStreamWriter(os, "UTF-8");
                XMLStreamWriterWrapper xsww = null;
                xsww = Docx4jProperties.getProperty("docx4j.jaxb.formatted.output", true) ? new XMLStreamWriterWrapperIndenting(this, xsw) : new XMLStreamWriterWrapper(this, xsw);
                marshaller.setListener((Marshaller.Listener)new Docx4jMarshallerListener(xsww, this.getPackage().isNew()));
                ((McIgnorableNamespaceDeclarator)namespacePrefixMapper).setMcIgnorable(mceIgnorable + this.getMcChoiceNamespaces());
                marshaller.marshal(this.jaxbElement, (XMLStreamWriter)xsww);
                xsww.close();
                xsw.close();
            }
            ((McIgnorableNamespaceDeclarator)namespacePrefixMapper).setMcIgnorable(null);
        }
        catch (Docx4JException e) {
            throw new JAXBException((Throwable)e);
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)e);
        }
    }

    public String getMceIgnorable() {
        return "";
    }

    protected void setMceIgnorable(McIgnorableNamespaceDeclarator namespacePrefixMapper) {
    }

    public String getMcChoiceNamespaces() {
        if (this.mcChoiceNamespaces.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : this.mcChoiceNamespaces) {
            sb.append(" " + s);
        }
        return sb.toString();
    }

    public void addMcChoiceNamespace(String mcChoiceNamespace) {
        this.mcChoiceNamespaces.add(mcChoiceNamespace);
    }

    protected Unmarshaller getConfiguredUnmarshaller(boolean eventHandlerContinue) throws JAXBException {
        Unmarshaller u = this.jc.createUnmarshaller();
        JaxbValidationEventHandler eventHandler = new JaxbValidationEventHandler();
        eventHandler.setContinue(eventHandlerContinue);
        u.setEventHandler((ValidationEventHandler)eventHandler);
        Docx4jUnmarshallerListener docx4jUnmarshallerListener = new Docx4jUnmarshallerListener(this);
        u.setListener((Unmarshaller.Listener)docx4jUnmarshallerListener);
        return u;
    }

    public E unmarshal(InputStream is) throws JAXBException {
        block9: {
            String transformParts = Docx4jProperties.getProperty("docx4j.jaxb.preprocess.always");
            boolean transformFirst = transformParts != null && transformParts.contains(this.getClass().getSimpleName());
            try {
                if (transformFirst) {
                    log.info("Preprocessing (transforming) this part");
                    this.preprocess(is, true);
                    return this.jaxbElement;
                }
                try {
                    this.jaxbElement = XmlUtils.unwrap(this.getConfiguredUnmarshaller(false).unmarshal(this.inputStreamToXSR(is)));
                    this.getPackage().getDrawingPropsIdTracker().deregisterPart(this);
                }
                catch (UnmarshalException ue) {
                    log.error(ue.getMessage(), (Throwable)ue);
                    if (ue.getLinkedException() != null && ue.getLinkedException().getMessage().contains("entity")) {
                        throw ue;
                    }
                    if (is.markSupported()) {
                        log.info("encountered unexpected content; pre-processing");
                        try {
                            is.reset();
                        }
                        catch (IOException e) {
                            throw new JAXBException("Preprocessing exception", (Throwable)e);
                        }
                        this.preprocess(is, true);
                        break block9;
                    }
                    throw new UnmarshalException("Mark not supported", (Throwable)ue);
                }
            }
            catch (XMLStreamException e1) {
                throw new JAXBException((Throwable)e1);
            }
        }
        return this.jaxbElement;
    }

    protected void preprocess(InputStream is, boolean eventHandlerContinue) throws JAXBException {
        try {
            this.jaxbElement = XmlUtils.unwrap(this.getConfiguredUnmarshaller(eventHandlerContinue).unmarshal((Node)this.transformToDom(this.inputStreamToXSR(is))));
            this.getPackage().getDrawingPropsIdTracker().deregisterPart(this);
        }
        catch (Exception e) {
            throw new JAXBException("Preprocessing exception", (Throwable)e);
        }
    }

    protected Document transformToDom(XMLStreamReader xsr) throws FactoryConfigurationError, JAXBException {
        Document doc = null;
        try {
            Templates mcPreprocessorXslt = JaxbValidationEventHandler.getMcPreprocessor();
            DOMResult result = new DOMResult();
            XmlUtils.transform(new StAXSource(xsr), mcPreprocessorXslt, null, (Result)result);
            doc = (Document)result.getNode();
        }
        catch (Exception e) {
            throw new JAXBException("Preprocessing exception", (Throwable)e);
        }
        return doc;
    }

    protected XMLStreamReader inputStreamToXSR(InputStream is) throws XMLStreamException {
        XMLInputFactory xif = StaXInputFactoryUtils.getXMLInputFactory();
        return xif.createXMLStreamReader(is);
    }

    public E unmarshal(Element el) throws JAXBException {
        try {
            try {
                this.jaxbElement = XmlUtils.unwrap(this.getConfiguredUnmarshaller(false).unmarshal((Node)el));
                this.getPackage().getDrawingPropsIdTracker().deregisterPart(this);
            }
            catch (UnmarshalException ue) {
                log.info("encountered unexpected content; pre-processing");
                try {
                    Document doc = el instanceof Document ? (Document)((Object)el) : el.getOwnerDocument();
                    DOMResult result = new DOMResult();
                    Templates mcPreprocessorXslt = JaxbValidationEventHandler.getMcPreprocessor();
                    XmlUtils.transform(doc, mcPreprocessorXslt, null, (Result)result);
                    this.jaxbElement = XmlUtils.unwrap(this.getConfiguredUnmarshaller(true).unmarshal((Node)((Document)result.getNode())));
                    this.getPackage().getDrawingPropsIdTracker().deregisterPart(this);
                }
                catch (Exception e) {
                    throw new JAXBException("Preprocessing exception", (Throwable)e);
                }
            }
            return this.jaxbElement;
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean isContentEqual(Part other) throws Docx4JException {
        log.debug("Comparing " + this.getPartName().getName() + " : " + other.getPartName().getName());
        if (!(other instanceof JaxbXmlPart)) {
            log.debug(other.getPartName().getName() + " is not a JaxbXmlPart");
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        try {
            this.marshal(baos);
            ((JaxbXmlPart)other).marshal(baos2);
        }
        catch (JAXBException e) {
            throw new Docx4JException("Error marshalling parts", (Exception)((Object)e));
        }
        return Arrays.equals(baos.toByteArray(), baos2.toByteArray());
    }

    static {
        MAX_BYTES_Unmarshal_Error = Docx4jProperties.getPropertyLong("docx4j.openpackaging.parts.MAX_BYTES.unmarshal.error", -1L);
    }
}

