/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common;

import java.io.OutputStream;
import org.docx4j.convert.out.AbstractConversionSettings;
import org.docx4j.convert.out.common.AbstractExporter;
import org.docx4j.convert.out.common.AbstractExporterDelegate;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.ConversionSectionWrappers;
import org.docx4j.convert.out.common.CreateWrappers;
import org.docx4j.convert.out.common.Preprocess;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Document;

public abstract class AbstractWmlExporter<CS extends AbstractConversionSettings, CC extends AbstractWmlConversionContext>
extends AbstractExporter<CS, CC, WordprocessingMLPackage> {
    protected AbstractExporterDelegate<CS, CC> exporterDelegate = null;

    protected AbstractWmlExporter(AbstractExporterDelegate<CS, CC> exporterDelegate) {
        this.exporterDelegate = exporterDelegate;
    }

    @Override
    protected WordprocessingMLPackage preprocess(CS conversionSettings) throws Docx4JException {
        WordprocessingMLPackage wmlPackage = null;
        try {
            wmlPackage = (WordprocessingMLPackage)((AbstractConversionSettings)conversionSettings).getOpcPackage();
        }
        catch (ClassCastException cce) {
            throw new Docx4JException("Invalid document package in the settings, it isn't a WordprocessingMLPackage");
        }
        if (wmlPackage == null) {
            throw new Docx4JException("Missing WordprocessingMLPackage in the conversion settings");
        }
        if (wmlPackage.getMainDocumentPart() == null) {
            throw new Docx4JException("MainDocumentPart missing");
        }
        if (wmlPackage.getMainDocumentPart().getContents() == null || ((Document)wmlPackage.getMainDocumentPart().getContents()).getBody() == null || ((Document)wmlPackage.getMainDocumentPart().getContents()).getBody().getContent().size() == 0) {
            throw new Docx4JException("MainDocumentPart empty");
        }
        return Preprocess.process(wmlPackage, ((AbstractConversionSettings)conversionSettings).getFeatures());
    }

    @Override
    protected ConversionSectionWrappers createWrappers(CS conversionSettings, WordprocessingMLPackage preprocessedPackage) throws Docx4JException {
        ConversionSectionWrappers ret = null;
        ret = CreateWrappers.process(preprocessedPackage, ((AbstractConversionSettings)conversionSettings).getFeatures());
        return ret;
    }

    @Override
    protected void process(CS conversionSettings, CC conversionContext, OutputStream outputStream) throws Docx4JException {
        this.exporterDelegate.process(conversionSettings, conversionContext, outputStream);
    }
}

