/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.headers;

import java.net.URI;
import org.dmfs.httpessentials.converters.IntegerConverter;
import org.dmfs.httpessentials.converters.LinkConverter;
import org.dmfs.httpessentials.converters.MediaTypeConverter;
import org.dmfs.httpessentials.converters.OptionallyQuoted;
import org.dmfs.httpessentials.converters.PlainStringHeaderConverter;
import org.dmfs.httpessentials.converters.UriConverter;
import org.dmfs.httpessentials.converters.UserAgentConverter;
import org.dmfs.httpessentials.headers.BasicListHeaderType;
import org.dmfs.httpessentials.headers.BasicSingletonHeaderType;
import org.dmfs.httpessentials.headers.ListHeaderType;
import org.dmfs.httpessentials.headers.SingletonHeaderType;
import org.dmfs.httpessentials.typedentity.EntityConverter;
import org.dmfs.httpessentials.types.Link;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.httpessentials.types.UserAgent;

public final class HttpHeaders {
    public static final SingletonHeaderType<MediaType> CONTENT_TYPE = new BasicSingletonHeaderType<MediaType>("content-type", (EntityConverter<MediaType>)MediaTypeConverter.INSTANCE);
    public static final SingletonHeaderType<Integer> CONTENT_LENGTH = new BasicSingletonHeaderType<Integer>("content-length", (EntityConverter<Integer>)IntegerConverter.INSTANCE);
    public static final ListHeaderType<Link> LINK = new BasicListHeaderType<Link>("link", (EntityConverter<Link>)new LinkConverter());
    public static final SingletonHeaderType<URI> LOCATION = new BasicSingletonHeaderType<URI>("location", (EntityConverter<URI>)UriConverter.INSTANCE);
    public static final SingletonHeaderType<UserAgent> USER_AGENT = new BasicSingletonHeaderType<UserAgent>("User-Agent", (EntityConverter<UserAgent>)new UserAgentConverter());
    private static final EntityConverter<String> OPTIONALLY_QUOTED_TEXT = new OptionallyQuoted((EntityConverter)PlainStringHeaderConverter.INSTANCE);
    public static final ListHeaderType<String> ACCEPT_ENCODING = new BasicListHeaderType<String>("accept-encoding", OPTIONALLY_QUOTED_TEXT);
    public static final ListHeaderType<String> CONTENT_ENCODING = new BasicListHeaderType<String>("content-encoding", OPTIONALLY_QUOTED_TEXT);

    private HttpHeaders() {
    }
}

