/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindUtil {
    public static <T> BindingProvider<T> fromConstructor(Class<T> type, Key ... keys) {
        return new ConstructorBindingProvider<T>(null, type, keys);
    }

    public static <T> BindingProvider<T> fromConstructor(Binder binder, Class<T> type, Key ... keys) {
        return new ConstructorBindingProvider<T>(binder, type, keys);
    }

    public static <T> BindingProvider<T> fromFactoryMethod(Class<T> providedType, Class<?> factoryType, String methodName, Key ... keys) {
        return new FactoryMethodBindingProvider<T>(null, providedType, Key.get(factoryType), methodName, keys);
    }

    public static <T> BindingProvider<T> fromFactoryMethod(Binder binder, Class<T> providedType, Class<?> factoryType, String methodName, Key ... keys) {
        return new FactoryMethodBindingProvider<T>(binder, providedType, Key.get(factoryType), methodName, keys);
    }

    public static <T> BindingProvider<T> fromFactoryMethod(Class<T> providedType, Key<?> factoryKey, String methodName, Key ... keys) {
        return new FactoryMethodBindingProvider<T>(null, providedType, factoryKey, methodName, keys);
    }

    public static <T> BindingProvider<T> fromFactoryMethod(Binder binder, Class<T> providedType, Key<?> factoryKey, String methodName, Key ... keys) {
        return new FactoryMethodBindingProvider<T>(binder, providedType, factoryKey, methodName, keys);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FactoryMethodBindingProvider<T>
    extends AbstractBindingProvider<T> {
        private final Method method;
        private final Key<?> factoryKey;

        FactoryMethodBindingProvider(Binder binder, Class<T> providedType, Key<?> factoryKey, String methodName, Key ... keys) {
            super(binder, providedType, keys);
            Method method = null;
            boolean isStaticFactory = false;
            try {
                Class factoryType = (Class)factoryKey.getTypeLiteral().getType();
                method = factoryType.getMethod(methodName, this.getTypes());
                method.getReturnType().asSubclass(providedType);
            }
            catch (NoSuchMethodException e) {
                if (binder == null) {
                    throw new IllegalArgumentException("no such method", e);
                }
                binder.addError((Throwable)e);
            }
            catch (ClassCastException e) {
                if (binder == null) {
                    throw new IllegalArgumentException("bad return type", e);
                }
                binder.addError((Throwable)e);
            }
            this.method = method;
            this.factoryKey = factoryKey;
        }

        @Override
        public T get(Injector injector) {
            try {
                Object target = null;
                if (!Modifier.isStatic(this.method.getModifiers())) {
                    target = injector.getInstance(this.factoryKey);
                }
                Object result = this.method.invoke(target, this.getValues(injector));
                return (T)result;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodBindingProvider<T>
    extends AbstractBindingProvider<T> {
        private final AbstractBindingProvider<T> prev;
        private final Method method;

        MethodBindingProvider(AbstractBindingProvider<T> prev, Class<T> type, String methodName, Key ... keys) {
            super(prev.binder, type, keys);
            Method method = null;
            try {
                method = type.getMethod(methodName, this.getTypes());
            }
            catch (NoSuchMethodException e) {
                if (this.binder == null) {
                    throw new IllegalArgumentException("no such method", e);
                }
                this.binder.addError((Throwable)e);
            }
            this.prev = prev;
            this.method = method;
        }

        @Override
        public T get(Injector injector) {
            T target = this.prev.get(injector);
            try {
                this.method.invoke(target, this.getValues(injector));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorBindingProvider<T>
    extends AbstractBindingProvider<T> {
        private final Constructor<T> constructor;

        ConstructorBindingProvider(Binder binder, Class<T> type, Key ... keys) {
            super(binder, type, keys);
            Constructor<T> constructor = null;
            try {
                constructor = type.getConstructor(this.getTypes());
            }
            catch (NoSuchMethodException e) {
                if (binder == null) {
                    throw new IllegalArgumentException("no such constructor", e);
                }
                binder.addError((Throwable)e);
            }
            this.constructor = constructor;
        }

        @Override
        public T get(Injector injector) {
            try {
                return this.constructor.newInstance(this.getValues(injector));
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractBindingProvider<T>
    implements BindingProvider<T> {
        protected final Binder binder;
        protected final Class<T> type;
        protected final Key[] keys;
        @Inject
        private Injector theInjector;

        protected AbstractBindingProvider(Binder binder, Class<T> type, Key ... keys) {
            this.binder = binder;
            this.type = type;
            this.keys = keys;
        }

        public final T get() {
            return this.get(this.theInjector);
        }

        protected abstract T get(Injector var1);

        @Override
        public final BindingProvider<T> injecting(String methodName, Key ... paramKeys) {
            return new MethodBindingProvider<T>(this, this.type, methodName, paramKeys);
        }

        protected final Class[] getTypes() {
            Class[] types = new Class[this.keys.length];
            int i = 0;
            for (Key key : this.keys) {
                Class type = (Class)key.getTypeLiteral().getType();
                types[i++] = type;
            }
            return types;
        }

        protected final Object[] getValues(Injector injector) {
            Object[] values = new Object[this.keys.length];
            int i = 0;
            for (Key key : this.keys) {
                Object param = injector.getInstance(key);
                values[i++] = param;
            }
            return values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BindingProvider<T>
    extends Provider<T> {
        public BindingProvider<T> injecting(String var1, Key ... var2);
    }
}

