/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dhatim.fastexcel.BorderElement;
import org.dhatim.fastexcel.BorderSide;
import org.dhatim.fastexcel.DiagonalProperty;
import org.dhatim.fastexcel.Writer;

class Border {
    protected static final Border NONE = new Border();
    final Map<BorderSide, BorderElement> elements = new EnumMap<BorderSide, BorderElement>(BorderSide.class);
    private final Set<DiagonalProperty> diagonalProperties = new HashSet<DiagonalProperty>();

    Border() {
        this(BorderElement.NONE, BorderElement.NONE, BorderElement.NONE, BorderElement.NONE, BorderElement.NONE);
    }

    Border(BorderElement element) {
        this(element, element, element, element, BorderElement.NONE);
    }

    Border(BorderElement left, BorderElement right, BorderElement top, BorderElement bottom, BorderElement diagonal) {
        this.elements.put(BorderSide.TOP, top);
        this.elements.put(BorderSide.LEFT, left);
        this.elements.put(BorderSide.BOTTOM, bottom);
        this.elements.put(BorderSide.RIGHT, right);
        this.elements.put(BorderSide.DIAGONAL, diagonal);
    }

    void setElement(BorderSide side, BorderElement element) {
        this.elements.put(side, element);
    }

    void setDiagonalProperty(DiagonalProperty diagonalProperty) {
        this.diagonalProperties.add(diagonalProperty);
    }

    static Border fromStyleAndColor(String style, String color) {
        BorderElement element = new BorderElement(style, color);
        return new Border(element, element, element, element, BorderElement.NONE);
    }

    public int hashCode() {
        return Objects.hash(this.elements, this.diagonalProperties);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj != null && obj.getClass() == this.getClass()) {
            Border other = (Border)obj;
            result = this.elements.equals(other.elements) && this.diagonalProperties.equals(other.diagonalProperties);
        } else {
            result = false;
        }
        return result;
    }

    void write(Writer w) throws IOException {
        w.append("<border");
        if (this.diagonalProperties.contains((Object)DiagonalProperty.DIAGONAL_UP)) {
            w.append(" diagonalUp=\"1\"");
        }
        if (this.diagonalProperties.contains((Object)DiagonalProperty.DIAGONAL_DOWN)) {
            w.append(" diagonalDown=\"1\"");
        }
        w.append(">");
        this.elements.get((Object)BorderSide.LEFT).write("left", w);
        this.elements.get((Object)BorderSide.RIGHT).write("right", w);
        this.elements.get((Object)BorderSide.TOP).write("top", w);
        this.elements.get((Object)BorderSide.BOTTOM).write("bottom", w);
        this.elements.get((Object)BorderSide.DIAGONAL).write("diagonal", w);
        w.append("</border>");
    }
}

