/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.util.data;

import java.io.IOException;
import java.util.List;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.deeplearning4j.spark.util.SparkUtils;
import org.deeplearning4j.spark.util.data.ValidationResult;
import org.deeplearning4j.spark.util.data.validation.ValidateDataSetFn;
import org.deeplearning4j.spark.util.data.validation.ValidateMultiDataSetFn;
import org.deeplearning4j.spark.util.data.validation.ValidationResultReduceFn;

public class SparkDataValidation {
    private SparkDataValidation() {
    }

    public static ValidationResult validateDataSets(JavaSparkContext sc, String path) {
        return SparkDataValidation.validateDataSets(sc, path, true, false, null, null);
    }

    public static ValidationResult validateDataSets(JavaSparkContext sc, String path, int[] featuresShape, int[] labelsShape) {
        return SparkDataValidation.validateDataSets(sc, path, true, false, featuresShape, labelsShape);
    }

    public static ValidationResult deleteInvalidDataSets(JavaSparkContext sc, String path) {
        return SparkDataValidation.validateDataSets(sc, path, true, true, null, null);
    }

    public static ValidationResult deleteInvalidDataSets(JavaSparkContext sc, String path, int[] featuresShape, int[] labelsShape) {
        return SparkDataValidation.validateDataSets(sc, path, true, true, featuresShape, labelsShape);
    }

    protected static ValidationResult validateDataSets(SparkContext sc, String path, boolean recursive, boolean deleteInvalid, int[] featuresShape, int[] labelsShape) {
        return SparkDataValidation.validateDataSets(new JavaSparkContext(sc), path, recursive, deleteInvalid, featuresShape, labelsShape);
    }

    protected static ValidationResult validateDataSets(JavaSparkContext sc, String path, boolean recursive, boolean deleteInvalid, int[] featuresShape, int[] labelsShape) {
        JavaRDD<String> paths;
        try {
            paths = SparkUtils.listPaths(sc, path, recursive);
        }
        catch (IOException e) {
            throw new RuntimeException("Error listing paths in directory", e);
        }
        JavaRDD results = paths.map((Function)new ValidateDataSetFn(deleteInvalid, featuresShape, labelsShape));
        return (ValidationResult)results.reduce((Function2)new ValidationResultReduceFn());
    }

    public static ValidationResult validateMultiDataSets(JavaSparkContext sc, String path) {
        return SparkDataValidation.validateMultiDataSets(sc, path, true, false, -1, -1, null, null);
    }

    public static ValidationResult validateMultiDataSets(JavaSparkContext sc, String path, int numFeatureArrays, int numLabelArrays) {
        return SparkDataValidation.validateMultiDataSets(sc, path, true, false, numFeatureArrays, numLabelArrays, null, null);
    }

    public static ValidationResult validateMultiDataSets(JavaSparkContext sc, String path, List<int[]> featuresShape, List<int[]> labelsShape) {
        return SparkDataValidation.validateMultiDataSets(sc, path, true, false, featuresShape == null ? -1 : featuresShape.size(), labelsShape == null ? -1 : labelsShape.size(), featuresShape, labelsShape);
    }

    public static ValidationResult deleteInvalidMultiDataSets(JavaSparkContext sc, String path) {
        return SparkDataValidation.validateMultiDataSets(sc, path, true, true, -1, -1, null, null);
    }

    public static ValidationResult deleteInvalidMultiDataSets(JavaSparkContext sc, String path, List<int[]> featuresShape, List<int[]> labelsShape) {
        return SparkDataValidation.validateMultiDataSets(sc, path, true, true, featuresShape == null ? -1 : featuresShape.size(), labelsShape == null ? -1 : labelsShape.size(), featuresShape, labelsShape);
    }

    public static ValidationResult deleteInvalidMultiDataSets(JavaSparkContext sc, String path, int numFeatureArrays, int numLabelArrays) {
        return SparkDataValidation.validateMultiDataSets(sc, path, true, true, numFeatureArrays, numLabelArrays, null, null);
    }

    protected static ValidationResult validateMultiDataSets(SparkContext sc, String path, boolean recursive, boolean deleteInvalid, int numFeatureArrays, int numLabelArrays, List<int[]> featuresShape, List<int[]> labelsShape) {
        return SparkDataValidation.validateMultiDataSets(new JavaSparkContext(sc), path, recursive, deleteInvalid, numFeatureArrays, numLabelArrays, featuresShape, labelsShape);
    }

    protected static ValidationResult validateMultiDataSets(JavaSparkContext sc, String path, boolean recursive, boolean deleteInvalid, int numFeatureArrays, int numLabelArrays, List<int[]> featuresShape, List<int[]> labelsShape) {
        JavaRDD<String> paths;
        try {
            paths = SparkUtils.listPaths(sc, path, recursive);
        }
        catch (IOException e) {
            throw new RuntimeException("Error listing paths in directory", e);
        }
        JavaRDD results = paths.map((Function)new ValidateMultiDataSetFn(deleteInvalid, numFeatureArrays, numLabelArrays, featuresShape, labelsShape));
        return (ValidationResult)results.reduce((Function2)new ValidationResultReduceFn());
    }
}

