/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.time;

import java.net.InetAddress;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.deeplearning4j.spark.time.TimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTPTimeSource
implements TimeSource {
    @Deprecated
    public static final String NTP_SOURCE_UPDATE_FREQUENCY_MS_PROPERTY = "org.deeplearning4j.spark.time.NTPTimeSource.frequencyms";
    @Deprecated
    public static final String NTP_SOURCE_SERVER_PROPERTY = "org.deeplearning4j.spark.time.NTPTimeSource.server";
    public static final int MAX_QUERY_RETRIES = 10;
    public static final int DEFAULT_NTP_TIMEOUT_MS = 10000;
    public static final long DEFAULT_UPDATE_FREQUENCY = 1800000L;
    public static final long MIN_UPDATE_FREQUENCY = 30000L;
    public static final String DEFAULT_NTP_SERVER = "0.pool.ntp.org";
    private static Logger log = LoggerFactory.getLogger(NTPTimeSource.class);
    private static NTPTimeSource instance;
    private volatile long lastOffsetGetTimeSystemMS = -1L;
    private volatile long lastOffsetMilliseconds;
    private final long synchronizationFreqMS;
    private final String ntpServer;

    public static synchronized TimeSource getInstance() {
        if (instance == null) {
            instance = new NTPTimeSource();
        }
        return instance;
    }

    private NTPTimeSource() {
        this(NTPTimeSource.getUpdateFrequencyConfiguration(), NTPTimeSource.getServerConfiguration());
    }

    private NTPTimeSource(long synchronizationFreqMS, String ntpServer) {
        this.synchronizationFreqMS = synchronizationFreqMS;
        this.ntpServer = ntpServer;
        log.debug("Initializing NTPTimeSource with query frequency {} ms using server {}", (Object)synchronizationFreqMS, (Object)ntpServer);
        this.queryServerNow();
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate((TimerTask)new QueryServerTask(), synchronizationFreqMS, synchronizationFreqMS);
        log.debug("Initialized NTPTimeSource with query frequency {} ms using server {}", (Object)synchronizationFreqMS, (Object)ntpServer);
    }

    private static long getUpdateFrequencyConfiguration() {
        long updateFreq;
        String property = System.getProperty(NTP_SOURCE_UPDATE_FREQUENCY_MS_PROPERTY);
        Long parseAttempt = null;
        if (property != null) {
            try {
                parseAttempt = Long.parseLong(property);
            }
            catch (Exception e) {
                log.info("Error parsing system property \"{}\" with value \"{}\"", (Object)NTP_SOURCE_UPDATE_FREQUENCY_MS_PROPERTY, (Object)property);
            }
            if (parseAttempt != null) {
                if (parseAttempt < 30000L) {
                    log.info("Invalid update frequency (milliseconds): {} is less than minimum {}. Using default update frequency: {} ms", new Object[]{parseAttempt, 30000L, 1800000L});
                    updateFreq = 1800000L;
                } else {
                    updateFreq = parseAttempt;
                }
            } else {
                updateFreq = 1800000L;
            }
        } else {
            updateFreq = 1800000L;
        }
        return updateFreq;
    }

    private static String getServerConfiguration() {
        return System.getProperty(NTP_SOURCE_SERVER_PROPERTY, DEFAULT_NTP_SERVER);
    }

    private void queryServerNow() {
        Long offsetResult = null;
        for (int i = 0; i < 10; ++i) {
            try {
                NTPUDPClient client = new NTPUDPClient();
                client.setDefaultTimeout(10000);
                client.open();
                InetAddress address = InetAddress.getByName(this.ntpServer);
                TimeInfo info = client.getTime(address);
                info.computeDetails();
                Long offset = info.getOffset();
                if (offset == null) {
                    throw new Exception("Could not calculate time offset (offset is null)");
                }
                offsetResult = offset;
                break;
            }
            catch (Exception e) {
                log.error("Error querying NTP server, attempt {} of {}", new Object[]{i + 1, 10, e});
                continue;
            }
        }
        if (offsetResult == null) {
            log.error("Could not successfully query NTP server after 10 tries");
            throw new RuntimeException("Could not successfully query NTP server after 10 tries");
        }
        this.lastOffsetGetTimeSystemMS = System.currentTimeMillis();
        this.lastOffsetMilliseconds = offsetResult;
        log.debug("Updated local time offset based on NTP server result. Offset = {}", (Object)this.lastOffsetMilliseconds);
    }

    private synchronized long getSystemOffset() {
        return this.lastOffsetMilliseconds;
    }

    @Override
    public long currentTimeMillis() {
        long offset = this.getSystemOffset();
        long systemTime = System.currentTimeMillis();
        return systemTime + offset;
    }

    private class QueryServerTask
    extends TimerTask {
        private QueryServerTask() {
        }

        @Override
        public void run() {
            NTPTimeSource.this.queryServerNow();
        }
    }
}

