/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.iterator;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import org.apache.spark.input.PortableDataStream;
import org.deeplearning4j.spark.iterator.BaseDataSetIterator;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.exception.ND4JArraySizeException;

public class PortableDataStreamDataSetIterator
extends BaseDataSetIterator<PortableDataStream> {
    public PortableDataStreamDataSetIterator(Iterator<PortableDataStream> iter) {
        this.dataSetStreams = null;
        this.iter = iter;
    }

    public PortableDataStreamDataSetIterator(Collection<PortableDataStream> dataSetStreams) {
        this.dataSetStreams = dataSetStreams;
        this.iter = dataSetStreams.iterator();
    }

    public org.nd4j.linalg.dataset.DataSet next() {
        org.nd4j.linalg.dataset.DataSet ds;
        if (this.preloadedDataSet != null) {
            ds = this.preloadedDataSet;
            this.preloadedDataSet = null;
        } else {
            ds = this.load((PortableDataStream)this.iter.next());
        }
        if (ds.getLabels().size(1) > Integer.MAX_VALUE || ds.getFeatures().size(1) > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        this.totalOutcomes = (int)ds.getLabels().size(1);
        this.inputColumns = (int)ds.getFeatures().size(1);
        this.batch = ds.numExamples();
        if (this.preprocessor != null) {
            this.preprocessor.preProcess((DataSet)ds);
        }
        return ds;
    }

    @Override
    protected org.nd4j.linalg.dataset.DataSet load(PortableDataStream pds) {
        org.nd4j.linalg.dataset.DataSet ds = new org.nd4j.linalg.dataset.DataSet();
        try (DataInputStream is = pds.open();){
            ds.load((InputStream)is);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading DataSet at path " + pds.getPath() + " - DataSet may be corrupt or invalid. Spark DataSets can be validated using org.deeplearning4j.spark.util.data.SparkDataValidation", e);
        }
        ++this.cursor;
        return ds;
    }
}

