/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.iterator;

import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.broadcast.Broadcast;
import org.datavec.spark.util.DefaultHadoopConfig;
import org.datavec.spark.util.SerializableHadoopConfig;
import org.deeplearning4j.core.loader.DataSetLoader;
import org.deeplearning4j.spark.data.loader.RemoteFileSource;
import org.deeplearning4j.spark.iterator.BaseDataSetIterator;
import org.nd4j.common.loader.Source;
import org.nd4j.linalg.dataset.api.DataSet;

public class PathSparkDataSetIterator
extends BaseDataSetIterator<String> {
    public static final int BUFFER_SIZE = 0x400000;
    private FileSystem fileSystem;
    private DataSetLoader dataSetLoader;
    private Broadcast<SerializableHadoopConfig> hadoopConfig;

    public PathSparkDataSetIterator(Iterator<String> iter, DataSetLoader dataSetLoader, Broadcast<SerializableHadoopConfig> hadoopConfig) {
        this.dataSetStreams = null;
        this.iter = iter;
        this.dataSetLoader = dataSetLoader;
        this.hadoopConfig = hadoopConfig;
    }

    public PathSparkDataSetIterator(Collection<String> dataSetStreams, DataSetLoader dataSetLoader, Broadcast<SerializableHadoopConfig> hadoopConfig) {
        this.dataSetStreams = dataSetStreams;
        this.iter = dataSetStreams.iterator();
        this.dataSetLoader = dataSetLoader;
        this.hadoopConfig = hadoopConfig;
    }

    public org.nd4j.linalg.dataset.DataSet next() {
        org.nd4j.linalg.dataset.DataSet ds;
        if (this.preloadedDataSet != null) {
            ds = this.preloadedDataSet;
            this.preloadedDataSet = null;
        } else {
            ds = this.load((String)this.iter.next());
        }
        this.totalOutcomes = ds.getLabels() == null ? 0L : (long)((int)ds.getLabels().size(1));
        this.inputColumns = (int)ds.getFeatures().size(1);
        this.batch = ds.numExamples();
        if (this.preprocessor != null) {
            this.preprocessor.preProcess((DataSet)ds);
        }
        return ds;
    }

    @Override
    protected synchronized org.nd4j.linalg.dataset.DataSet load(String path) {
        if (this.fileSystem == null) {
            try {
                Configuration c = this.hadoopConfig == null ? DefaultHadoopConfig.get() : ((SerializableHadoopConfig)this.hadoopConfig.getValue()).getConfiguration();
                this.fileSystem = FileSystem.get((URI)new URI(path), (Configuration)c);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ++this.cursor;
        try {
            return (org.nd4j.linalg.dataset.DataSet)this.dataSetLoader.load((Source)new RemoteFileSource(path, this.fileSystem, 0x400000));
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading DataSet at path " + path + " - DataSet may be corrupt or invalid. Spark DataSets can be validated using org.deeplearning4j.spark.util.data.SparkDataValidation", e);
        }
    }
}

