/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.iterator;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.exception.ND4JArraySizeException;

public abstract class BaseDataSetIterator<T>
implements DataSetIterator {
    protected Collection<T> dataSetStreams;
    protected DataSetPreProcessor preprocessor;
    protected Iterator<T> iter;
    protected long totalOutcomes = -1L;
    protected long inputColumns = -1L;
    protected int batch = -1;
    protected DataSet preloadedDataSet;
    protected int cursor = 0;

    public DataSet next(int num) {
        return (DataSet)this.next();
    }

    public int inputColumns() {
        if (this.inputColumns == -1L) {
            this.preloadDataSet();
        }
        return (int)this.inputColumns;
    }

    public int totalOutcomes() {
        if (this.totalOutcomes == -1L) {
            this.preloadDataSet();
        }
        if (this.preloadedDataSet == null || this.preloadedDataSet.getLabels() == null) {
            return 0;
        }
        return (int)this.preloadedDataSet.getLabels().size(1);
    }

    public boolean resetSupported() {
        return this.dataSetStreams != null;
    }

    public boolean asyncSupported() {
        return true;
    }

    public void reset() {
        if (this.dataSetStreams == null) {
            throw new IllegalStateException("Cannot reset iterator constructed with an iterator");
        }
        this.iter = this.dataSetStreams.iterator();
        this.cursor = 0;
    }

    public int batch() {
        if (this.batch == -1) {
            this.preloadDataSet();
        }
        return this.batch;
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preprocessor = preProcessor;
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preprocessor;
    }

    public List<String> getLabels() {
        return null;
    }

    public boolean hasNext() {
        return this.preloadedDataSet != null || this.iter.hasNext();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void preloadDataSet() {
        this.preloadedDataSet = this.load(this.iter.next());
        if (this.preloadedDataSet.getLabels().size(1) > Integer.MAX_VALUE || this.preloadedDataSet.getFeatures().size(1) > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        this.totalOutcomes = (int)this.preloadedDataSet.getLabels().size(1);
        this.inputColumns = (int)this.preloadedDataSet.getFeatures().size(1);
    }

    protected abstract DataSet load(T var1);
}

