/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.repartitioner;

import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.deeplearning4j.spark.api.Repartitioner;
import org.deeplearning4j.spark.impl.common.CountPartitionsFunction;
import org.deeplearning4j.spark.impl.repartitioner.EqualRepartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class DefaultRepartitioner
implements Repartitioner {
    private static final Logger log = LoggerFactory.getLogger(DefaultRepartitioner.class);
    public static final int DEFAULT_MAX_PARTITIONS = 5000;
    private final int maxPartitions;

    public DefaultRepartitioner() {
        this(5000);
    }

    public DefaultRepartitioner(int maxPartitions) {
        this.maxPartitions = maxPartitions;
    }

    @Override
    public <T> JavaRDD<T> repartition(JavaRDD<T> rdd, int minObjectsPerPartition, int numExecutors) {
        List partitionCounts = rdd.mapPartitionsWithIndex(new CountPartitionsFunction(), true).collect();
        int totalObjects = 0;
        for (Tuple2 t2 : partitionCounts) {
            totalObjects += ((Integer)t2._2()).intValue();
        }
        int numPartitions = totalObjects / minObjectsPerPartition > this.maxPartitions ? this.maxPartitions : (int)Math.ceil((double)totalObjects / (double)minObjectsPerPartition);
        return EqualRepartitioner.repartition(rdd, numPartitions, partitionCounts);
    }

    public String toString() {
        return "DefaultRepartitioner(maxPartitions=" + this.maxPartitions + ")";
    }
}

