/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.paramavg.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.spark.SparkContext;
import org.deeplearning4j.spark.api.stats.SparkTrainingStats;
import org.deeplearning4j.spark.stats.BaseEventStats;
import org.deeplearning4j.spark.stats.EventStats;
import org.deeplearning4j.spark.stats.ExampleCountEventStats;
import org.deeplearning4j.spark.stats.PartitionCountEventStats;
import org.deeplearning4j.spark.stats.StatsUtils;
import org.deeplearning4j.spark.time.TimeSource;
import org.deeplearning4j.spark.time.TimeSourceProvider;

public class ParameterAveragingTrainingMasterStats
implements SparkTrainingStats {
    public static final String DEFAULT_DELIMITER = ",";
    public static final String FILENAME_EXPORT_RDD_TIME = "parameterAveragingMasterExportTimesMs.txt";
    public static final String FILENAME_COUNT_RDD_SIZE = "parameterAveragingMasterCountRddSizeTimesMs.txt";
    public static final String FILENAME_BROADCAST_CREATE = "parameterAveragingMasterBroadcastCreateTimesMs.txt";
    public static final String FILENAME_FIT_TIME = "parameterAveragingMasterFitTimesMs.txt";
    public static final String FILENAME_SPLIT_TIME = "parameterAveragingMasterSplitTimesMs.txt";
    public static final String FILENAME_MAP_PARTITIONS_TIME = "parameterAveragingMasterMapPartitionsTimesMs.txt";
    public static final String FILENAME_AGGREGATE_TIME = "parameterAveragingMasterAggregateTimesMs.txt";
    public static final String FILENAME_PROCESS_PARAMS_TIME = "parameterAveragingMasterProcessParamsUpdaterTimesMs.txt";
    public static final String FILENAME_REPARTITION_STATS = "parameterAveragingMasterRepartitionTimesMs.txt";
    public static final String PARAMETER_AVERAGING_MASTER_EXPORT_RDD_TIMES_MS = "parameterAveragingMasterExportTimesMs";
    public static final String PARAMETER_AVERAGING_MASTER_COUNT_RDD_TIMES_MS = "ParameterAveragingMasterCountRddSizeTimesMs";
    public static final String PARAMETER_AVERAGING_MASTER_BROADCAST_CREATE_TIMES_MS = "ParameterAveragingMasterBroadcastCreateTimesMs";
    public static final String PARAMETER_AVERAGING_MASTER_FIT_TIMES_MS = "ParameterAveragingMasterFitTimesMs";
    public static final String PARAMETER_AVERAGING_MASTER_SPLIT_TIMES_MS = "ParameterAveragingMasterSplitTimesMs";
    public static final String PARAMETER_AVERAGING_MASTER_MAP_PARTITIONS_TIMES_MS = "ParameterAveragingMasterMapPartitionsTimesMs";
    public static final String PARAMETER_AVERAGING_MASTER_AGGREGATE_TIMES_MS = "ParameterAveragingMasterAggregateTimesMs";
    public static final String PARAMETER_AVERAGING_MASTER_PROCESS_PARAMS_UPDATER_TIMES_MS = "ParameterAveragingMasterProcessParamsUpdaterTimesMs";
    public static final String PARAMETER_AVERAGING_MASTER_REPARTITION_TIMES_MS = "ParameterAveragingMasterRepartitionTimesMs";
    private static Set<String> columnNames = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("parameterAveragingMasterExportTimesMs", "ParameterAveragingMasterCountRddSizeTimesMs", "ParameterAveragingMasterBroadcastCreateTimesMs", "ParameterAveragingMasterFitTimesMs", "ParameterAveragingMasterSplitTimesMs", "ParameterAveragingMasterMapPartitionsTimesMs", "ParameterAveragingMasterAggregateTimesMs", "ParameterAveragingMasterProcessParamsUpdaterTimesMs", "ParameterAveragingMasterRepartitionTimesMs")));
    private SparkTrainingStats workerStats;
    private List<EventStats> parameterAveragingMasterExportTimesMs;
    private List<EventStats> parameterAveragingMasterCountRddSizeTimesMs;
    private List<EventStats> parameterAveragingMasterBroadcastCreateTimesMs;
    private List<EventStats> parameterAveragingMasterFitTimesMs;
    private List<EventStats> parameterAveragingMasterSplitTimesMs;
    private List<EventStats> parameterAveragingMasterMapPartitionsTimesMs;
    private List<EventStats> paramaterAveragingMasterAggregateTimesMs;
    private List<EventStats> parameterAveragingMasterProcessParamsUpdaterTimesMs;
    private List<EventStats> parameterAveragingMasterRepartitionTimesMs;

    public ParameterAveragingTrainingMasterStats(SparkTrainingStats workerStats, List<EventStats> parameterAveragingMasterExportTimesMs, List<EventStats> parameterAveragingMasterCountRddSizeTimesMs, List<EventStats> parameterAveragingMasterBroadcastCreateTimeMs, List<EventStats> parameterAveragingMasterFitTimeMs, List<EventStats> parameterAveragingMasterSplitTimeMs, List<EventStats> parameterAveragingMasterMapPartitionsTimesMs, List<EventStats> parameterAveragingMasterAggregateTimesMs, List<EventStats> parameterAveragingMasterProcessParamsUpdaterTimesMs, List<EventStats> parameterAveragingMasterRepartitionTimesMs) {
        this.workerStats = workerStats;
        this.parameterAveragingMasterExportTimesMs = parameterAveragingMasterExportTimesMs;
        this.parameterAveragingMasterCountRddSizeTimesMs = parameterAveragingMasterCountRddSizeTimesMs;
        this.parameterAveragingMasterBroadcastCreateTimesMs = parameterAveragingMasterBroadcastCreateTimeMs;
        this.parameterAveragingMasterFitTimesMs = parameterAveragingMasterFitTimeMs;
        this.parameterAveragingMasterSplitTimesMs = parameterAveragingMasterSplitTimeMs;
        this.parameterAveragingMasterMapPartitionsTimesMs = parameterAveragingMasterMapPartitionsTimesMs;
        this.paramaterAveragingMasterAggregateTimesMs = parameterAveragingMasterAggregateTimesMs;
        this.parameterAveragingMasterProcessParamsUpdaterTimesMs = parameterAveragingMasterProcessParamsUpdaterTimesMs;
        this.parameterAveragingMasterRepartitionTimesMs = parameterAveragingMasterRepartitionTimesMs;
    }

    @Override
    public Set<String> getKeySet() {
        LinkedHashSet<String> out = new LinkedHashSet<String>(columnNames);
        if (this.workerStats != null) {
            out.addAll(this.workerStats.getKeySet());
        }
        return out;
    }

    @Override
    public List<EventStats> getValue(String key) {
        switch (key) {
            case "parameterAveragingMasterExportTimesMs": {
                return this.parameterAveragingMasterExportTimesMs;
            }
            case "ParameterAveragingMasterCountRddSizeTimesMs": {
                return this.parameterAveragingMasterCountRddSizeTimesMs;
            }
            case "ParameterAveragingMasterBroadcastCreateTimesMs": {
                return this.parameterAveragingMasterBroadcastCreateTimesMs;
            }
            case "ParameterAveragingMasterFitTimesMs": {
                return this.parameterAveragingMasterFitTimesMs;
            }
            case "ParameterAveragingMasterSplitTimesMs": {
                return this.parameterAveragingMasterSplitTimesMs;
            }
            case "ParameterAveragingMasterMapPartitionsTimesMs": {
                return this.parameterAveragingMasterMapPartitionsTimesMs;
            }
            case "ParameterAveragingMasterAggregateTimesMs": {
                return this.paramaterAveragingMasterAggregateTimesMs;
            }
            case "ParameterAveragingMasterProcessParamsUpdaterTimesMs": {
                return this.parameterAveragingMasterProcessParamsUpdaterTimesMs;
            }
            case "ParameterAveragingMasterRepartitionTimesMs": {
                return this.parameterAveragingMasterRepartitionTimesMs;
            }
        }
        if (this.workerStats != null) {
            return this.workerStats.getValue(key);
        }
        throw new IllegalArgumentException("Unknown key: \"" + key + "\"");
    }

    @Override
    public String getShortNameForKey(String key) {
        switch (key) {
            case "parameterAveragingMasterExportTimesMs": {
                return "Export";
            }
            case "ParameterAveragingMasterCountRddSizeTimesMs": {
                return "CountRDD";
            }
            case "ParameterAveragingMasterBroadcastCreateTimesMs": {
                return "CreateBroadcast";
            }
            case "ParameterAveragingMasterFitTimesMs": {
                return "Fit";
            }
            case "ParameterAveragingMasterSplitTimesMs": {
                return "Split";
            }
            case "ParameterAveragingMasterMapPartitionsTimesMs": {
                return "MapPart";
            }
            case "ParameterAveragingMasterAggregateTimesMs": {
                return "Aggregate";
            }
            case "ParameterAveragingMasterProcessParamsUpdaterTimesMs": {
                return "ProcessParams";
            }
            case "ParameterAveragingMasterRepartitionTimesMs": {
                return "Repartition";
            }
        }
        if (this.workerStats != null) {
            return this.workerStats.getShortNameForKey(key);
        }
        throw new IllegalArgumentException("Unknown key: \"" + key + "\"");
    }

    @Override
    public boolean defaultIncludeInPlots(String key) {
        switch (key) {
            case "ParameterAveragingMasterFitTimesMs": 
            case "ParameterAveragingMasterMapPartitionsTimesMs": {
                return false;
            }
            case "parameterAveragingMasterExportTimesMs": 
            case "ParameterAveragingMasterCountRddSizeTimesMs": 
            case "ParameterAveragingMasterSplitTimesMs": 
            case "ParameterAveragingMasterBroadcastCreateTimesMs": 
            case "ParameterAveragingMasterAggregateTimesMs": 
            case "ParameterAveragingMasterProcessParamsUpdaterTimesMs": 
            case "ParameterAveragingMasterRepartitionTimesMs": {
                return true;
            }
        }
        if (this.workerStats != null) {
            return this.workerStats.defaultIncludeInPlots(key);
        }
        return false;
    }

    @Override
    public void addOtherTrainingStats(SparkTrainingStats other) {
        if (!(other instanceof ParameterAveragingTrainingMasterStats)) {
            throw new IllegalArgumentException("Expected ParameterAveragingTrainingMasterStats, got " + (other != null ? other.getClass() : null));
        }
        ParameterAveragingTrainingMasterStats o = (ParameterAveragingTrainingMasterStats)other;
        if (this.workerStats != null) {
            if (o.workerStats != null) {
                this.workerStats.addOtherTrainingStats(o.workerStats);
            }
        } else if (o.workerStats != null) {
            this.workerStats = o.workerStats;
        }
        this.parameterAveragingMasterExportTimesMs.addAll(o.parameterAveragingMasterExportTimesMs);
        this.parameterAveragingMasterCountRddSizeTimesMs.addAll(o.parameterAveragingMasterCountRddSizeTimesMs);
        this.parameterAveragingMasterBroadcastCreateTimesMs.addAll(o.parameterAveragingMasterBroadcastCreateTimesMs);
        this.parameterAveragingMasterRepartitionTimesMs.addAll(o.parameterAveragingMasterRepartitionTimesMs);
        this.parameterAveragingMasterFitTimesMs.addAll(o.parameterAveragingMasterFitTimesMs);
        if (this.parameterAveragingMasterRepartitionTimesMs == null) {
            if (o.parameterAveragingMasterRepartitionTimesMs != null) {
                this.parameterAveragingMasterRepartitionTimesMs = o.parameterAveragingMasterRepartitionTimesMs;
            }
        } else if (o.parameterAveragingMasterRepartitionTimesMs != null) {
            this.parameterAveragingMasterRepartitionTimesMs.addAll(o.parameterAveragingMasterRepartitionTimesMs);
        }
    }

    @Override
    public SparkTrainingStats getNestedTrainingStats() {
        return this.workerStats;
    }

    @Override
    public String statsAsString() {
        StringBuilder sb = new StringBuilder();
        String f = "%-55s";
        sb.append(String.format(f, PARAMETER_AVERAGING_MASTER_EXPORT_RDD_TIMES_MS));
        if (this.parameterAveragingMasterExportTimesMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.parameterAveragingMasterExportTimesMs, DEFAULT_DELIMITER)).append("\n");
        }
        sb.append(String.format(f, PARAMETER_AVERAGING_MASTER_COUNT_RDD_TIMES_MS));
        if (this.parameterAveragingMasterCountRddSizeTimesMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.parameterAveragingMasterCountRddSizeTimesMs, DEFAULT_DELIMITER)).append("\n");
        }
        sb.append(String.format(f, PARAMETER_AVERAGING_MASTER_BROADCAST_CREATE_TIMES_MS));
        if (this.parameterAveragingMasterBroadcastCreateTimesMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.parameterAveragingMasterBroadcastCreateTimesMs, DEFAULT_DELIMITER)).append("\n");
        }
        sb.append(String.format(f, PARAMETER_AVERAGING_MASTER_REPARTITION_TIMES_MS));
        if (this.parameterAveragingMasterRepartitionTimesMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.parameterAveragingMasterRepartitionTimesMs, DEFAULT_DELIMITER)).append("\n");
        }
        sb.append(String.format(f, PARAMETER_AVERAGING_MASTER_FIT_TIMES_MS));
        if (this.parameterAveragingMasterFitTimesMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.parameterAveragingMasterFitTimesMs, DEFAULT_DELIMITER)).append("\n");
        }
        sb.append(String.format(f, PARAMETER_AVERAGING_MASTER_SPLIT_TIMES_MS));
        if (this.parameterAveragingMasterSplitTimesMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.parameterAveragingMasterSplitTimesMs, DEFAULT_DELIMITER)).append("\n");
        }
        sb.append(String.format(f, PARAMETER_AVERAGING_MASTER_MAP_PARTITIONS_TIMES_MS));
        if (this.parameterAveragingMasterMapPartitionsTimesMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.parameterAveragingMasterMapPartitionsTimesMs, DEFAULT_DELIMITER)).append("\n");
        }
        sb.append(String.format(f, PARAMETER_AVERAGING_MASTER_AGGREGATE_TIMES_MS));
        if (this.paramaterAveragingMasterAggregateTimesMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.paramaterAveragingMasterAggregateTimesMs, DEFAULT_DELIMITER)).append("\n");
        }
        sb.append(String.format(f, PARAMETER_AVERAGING_MASTER_PROCESS_PARAMS_UPDATER_TIMES_MS));
        if (this.parameterAveragingMasterProcessParamsUpdaterTimesMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.parameterAveragingMasterProcessParamsUpdaterTimesMs, DEFAULT_DELIMITER)).append("\n");
        }
        if (this.workerStats != null) {
            sb.append(this.workerStats.statsAsString());
        }
        return sb.toString();
    }

    @Override
    public void exportStatFiles(String outputPath, SparkContext sc) throws IOException {
        String d = DEFAULT_DELIMITER;
        String exportRddPath = FilenameUtils.concat((String)outputPath, (String)FILENAME_EXPORT_RDD_TIME);
        StatsUtils.exportStats(this.parameterAveragingMasterExportTimesMs, exportRddPath, d, sc);
        String countRddPath = FilenameUtils.concat((String)outputPath, (String)FILENAME_COUNT_RDD_SIZE);
        StatsUtils.exportStats(this.parameterAveragingMasterCountRddSizeTimesMs, countRddPath, d, sc);
        String broadcastTimePath = FilenameUtils.concat((String)outputPath, (String)FILENAME_BROADCAST_CREATE);
        StatsUtils.exportStats(this.parameterAveragingMasterBroadcastCreateTimesMs, broadcastTimePath, d, sc);
        String repartitionTime = FilenameUtils.concat((String)outputPath, (String)FILENAME_REPARTITION_STATS);
        StatsUtils.exportStats(this.parameterAveragingMasterRepartitionTimesMs, repartitionTime, d, sc);
        String fitTimePath = FilenameUtils.concat((String)outputPath, (String)FILENAME_FIT_TIME);
        StatsUtils.exportStats(this.parameterAveragingMasterFitTimesMs, fitTimePath, d, sc);
        String splitTimePath = FilenameUtils.concat((String)outputPath, (String)FILENAME_SPLIT_TIME);
        StatsUtils.exportStats(this.parameterAveragingMasterSplitTimesMs, splitTimePath, d, sc);
        String mapPartitionsPath = FilenameUtils.concat((String)outputPath, (String)FILENAME_MAP_PARTITIONS_TIME);
        StatsUtils.exportStats(this.parameterAveragingMasterMapPartitionsTimesMs, mapPartitionsPath, d, sc);
        String aggregatePath = FilenameUtils.concat((String)outputPath, (String)FILENAME_AGGREGATE_TIME);
        StatsUtils.exportStats(this.paramaterAveragingMasterAggregateTimesMs, aggregatePath, d, sc);
        String processParamsPath = FilenameUtils.concat((String)outputPath, (String)FILENAME_PROCESS_PARAMS_TIME);
        StatsUtils.exportStats(this.parameterAveragingMasterProcessParamsUpdaterTimesMs, processParamsPath, d, sc);
        if (this.parameterAveragingMasterRepartitionTimesMs != null) {
            String repartitionPath = FilenameUtils.concat((String)outputPath, (String)FILENAME_REPARTITION_STATS);
            StatsUtils.exportStats(this.parameterAveragingMasterRepartitionTimesMs, repartitionPath, d, sc);
        }
        if (this.workerStats != null) {
            this.workerStats.exportStatFiles(outputPath, sc);
        }
    }

    public SparkTrainingStats getWorkerStats() {
        return this.workerStats;
    }

    public List<EventStats> getParameterAveragingMasterExportTimesMs() {
        return this.parameterAveragingMasterExportTimesMs;
    }

    public List<EventStats> getParameterAveragingMasterCountRddSizeTimesMs() {
        return this.parameterAveragingMasterCountRddSizeTimesMs;
    }

    public List<EventStats> getParameterAveragingMasterBroadcastCreateTimesMs() {
        return this.parameterAveragingMasterBroadcastCreateTimesMs;
    }

    public List<EventStats> getParameterAveragingMasterFitTimesMs() {
        return this.parameterAveragingMasterFitTimesMs;
    }

    public List<EventStats> getParameterAveragingMasterSplitTimesMs() {
        return this.parameterAveragingMasterSplitTimesMs;
    }

    public List<EventStats> getParameterAveragingMasterMapPartitionsTimesMs() {
        return this.parameterAveragingMasterMapPartitionsTimesMs;
    }

    public List<EventStats> getParamaterAveragingMasterAggregateTimesMs() {
        return this.paramaterAveragingMasterAggregateTimesMs;
    }

    public List<EventStats> getParameterAveragingMasterProcessParamsUpdaterTimesMs() {
        return this.parameterAveragingMasterProcessParamsUpdaterTimesMs;
    }

    public List<EventStats> getParameterAveragingMasterRepartitionTimesMs() {
        return this.parameterAveragingMasterRepartitionTimesMs;
    }

    public void setWorkerStats(SparkTrainingStats workerStats) {
        this.workerStats = workerStats;
    }

    public void setParameterAveragingMasterExportTimesMs(List<EventStats> parameterAveragingMasterExportTimesMs) {
        this.parameterAveragingMasterExportTimesMs = parameterAveragingMasterExportTimesMs;
    }

    public void setParameterAveragingMasterCountRddSizeTimesMs(List<EventStats> parameterAveragingMasterCountRddSizeTimesMs) {
        this.parameterAveragingMasterCountRddSizeTimesMs = parameterAveragingMasterCountRddSizeTimesMs;
    }

    public void setParameterAveragingMasterBroadcastCreateTimesMs(List<EventStats> parameterAveragingMasterBroadcastCreateTimesMs) {
        this.parameterAveragingMasterBroadcastCreateTimesMs = parameterAveragingMasterBroadcastCreateTimesMs;
    }

    public void setParameterAveragingMasterFitTimesMs(List<EventStats> parameterAveragingMasterFitTimesMs) {
        this.parameterAveragingMasterFitTimesMs = parameterAveragingMasterFitTimesMs;
    }

    public void setParameterAveragingMasterSplitTimesMs(List<EventStats> parameterAveragingMasterSplitTimesMs) {
        this.parameterAveragingMasterSplitTimesMs = parameterAveragingMasterSplitTimesMs;
    }

    public void setParameterAveragingMasterMapPartitionsTimesMs(List<EventStats> parameterAveragingMasterMapPartitionsTimesMs) {
        this.parameterAveragingMasterMapPartitionsTimesMs = parameterAveragingMasterMapPartitionsTimesMs;
    }

    public void setParamaterAveragingMasterAggregateTimesMs(List<EventStats> paramaterAveragingMasterAggregateTimesMs) {
        this.paramaterAveragingMasterAggregateTimesMs = paramaterAveragingMasterAggregateTimesMs;
    }

    public void setParameterAveragingMasterProcessParamsUpdaterTimesMs(List<EventStats> parameterAveragingMasterProcessParamsUpdaterTimesMs) {
        this.parameterAveragingMasterProcessParamsUpdaterTimesMs = parameterAveragingMasterProcessParamsUpdaterTimesMs;
    }

    public void setParameterAveragingMasterRepartitionTimesMs(List<EventStats> parameterAveragingMasterRepartitionTimesMs) {
        this.parameterAveragingMasterRepartitionTimesMs = parameterAveragingMasterRepartitionTimesMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterAveragingTrainingMasterStats)) {
            return false;
        }
        ParameterAveragingTrainingMasterStats other = (ParameterAveragingTrainingMasterStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SparkTrainingStats this$workerStats = this.getWorkerStats();
        SparkTrainingStats other$workerStats = other.getWorkerStats();
        if (this$workerStats == null ? other$workerStats != null : !this$workerStats.equals(other$workerStats)) {
            return false;
        }
        List<EventStats> this$parameterAveragingMasterExportTimesMs = this.getParameterAveragingMasterExportTimesMs();
        List<EventStats> other$parameterAveragingMasterExportTimesMs = other.getParameterAveragingMasterExportTimesMs();
        if (this$parameterAveragingMasterExportTimesMs == null ? other$parameterAveragingMasterExportTimesMs != null : !((Object)this$parameterAveragingMasterExportTimesMs).equals(other$parameterAveragingMasterExportTimesMs)) {
            return false;
        }
        List<EventStats> this$parameterAveragingMasterCountRddSizeTimesMs = this.getParameterAveragingMasterCountRddSizeTimesMs();
        List<EventStats> other$parameterAveragingMasterCountRddSizeTimesMs = other.getParameterAveragingMasterCountRddSizeTimesMs();
        if (this$parameterAveragingMasterCountRddSizeTimesMs == null ? other$parameterAveragingMasterCountRddSizeTimesMs != null : !((Object)this$parameterAveragingMasterCountRddSizeTimesMs).equals(other$parameterAveragingMasterCountRddSizeTimesMs)) {
            return false;
        }
        List<EventStats> this$parameterAveragingMasterBroadcastCreateTimesMs = this.getParameterAveragingMasterBroadcastCreateTimesMs();
        List<EventStats> other$parameterAveragingMasterBroadcastCreateTimesMs = other.getParameterAveragingMasterBroadcastCreateTimesMs();
        if (this$parameterAveragingMasterBroadcastCreateTimesMs == null ? other$parameterAveragingMasterBroadcastCreateTimesMs != null : !((Object)this$parameterAveragingMasterBroadcastCreateTimesMs).equals(other$parameterAveragingMasterBroadcastCreateTimesMs)) {
            return false;
        }
        List<EventStats> this$parameterAveragingMasterFitTimesMs = this.getParameterAveragingMasterFitTimesMs();
        List<EventStats> other$parameterAveragingMasterFitTimesMs = other.getParameterAveragingMasterFitTimesMs();
        if (this$parameterAveragingMasterFitTimesMs == null ? other$parameterAveragingMasterFitTimesMs != null : !((Object)this$parameterAveragingMasterFitTimesMs).equals(other$parameterAveragingMasterFitTimesMs)) {
            return false;
        }
        List<EventStats> this$parameterAveragingMasterSplitTimesMs = this.getParameterAveragingMasterSplitTimesMs();
        List<EventStats> other$parameterAveragingMasterSplitTimesMs = other.getParameterAveragingMasterSplitTimesMs();
        if (this$parameterAveragingMasterSplitTimesMs == null ? other$parameterAveragingMasterSplitTimesMs != null : !((Object)this$parameterAveragingMasterSplitTimesMs).equals(other$parameterAveragingMasterSplitTimesMs)) {
            return false;
        }
        List<EventStats> this$parameterAveragingMasterMapPartitionsTimesMs = this.getParameterAveragingMasterMapPartitionsTimesMs();
        List<EventStats> other$parameterAveragingMasterMapPartitionsTimesMs = other.getParameterAveragingMasterMapPartitionsTimesMs();
        if (this$parameterAveragingMasterMapPartitionsTimesMs == null ? other$parameterAveragingMasterMapPartitionsTimesMs != null : !((Object)this$parameterAveragingMasterMapPartitionsTimesMs).equals(other$parameterAveragingMasterMapPartitionsTimesMs)) {
            return false;
        }
        List<EventStats> this$paramaterAveragingMasterAggregateTimesMs = this.getParamaterAveragingMasterAggregateTimesMs();
        List<EventStats> other$paramaterAveragingMasterAggregateTimesMs = other.getParamaterAveragingMasterAggregateTimesMs();
        if (this$paramaterAveragingMasterAggregateTimesMs == null ? other$paramaterAveragingMasterAggregateTimesMs != null : !((Object)this$paramaterAveragingMasterAggregateTimesMs).equals(other$paramaterAveragingMasterAggregateTimesMs)) {
            return false;
        }
        List<EventStats> this$parameterAveragingMasterProcessParamsUpdaterTimesMs = this.getParameterAveragingMasterProcessParamsUpdaterTimesMs();
        List<EventStats> other$parameterAveragingMasterProcessParamsUpdaterTimesMs = other.getParameterAveragingMasterProcessParamsUpdaterTimesMs();
        if (this$parameterAveragingMasterProcessParamsUpdaterTimesMs == null ? other$parameterAveragingMasterProcessParamsUpdaterTimesMs != null : !((Object)this$parameterAveragingMasterProcessParamsUpdaterTimesMs).equals(other$parameterAveragingMasterProcessParamsUpdaterTimesMs)) {
            return false;
        }
        List<EventStats> this$parameterAveragingMasterRepartitionTimesMs = this.getParameterAveragingMasterRepartitionTimesMs();
        List<EventStats> other$parameterAveragingMasterRepartitionTimesMs = other.getParameterAveragingMasterRepartitionTimesMs();
        return !(this$parameterAveragingMasterRepartitionTimesMs == null ? other$parameterAveragingMasterRepartitionTimesMs != null : !((Object)this$parameterAveragingMasterRepartitionTimesMs).equals(other$parameterAveragingMasterRepartitionTimesMs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParameterAveragingTrainingMasterStats;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SparkTrainingStats $workerStats = this.getWorkerStats();
        result = result * 59 + ($workerStats == null ? 43 : $workerStats.hashCode());
        List<EventStats> $parameterAveragingMasterExportTimesMs = this.getParameterAveragingMasterExportTimesMs();
        result = result * 59 + ($parameterAveragingMasterExportTimesMs == null ? 43 : ((Object)$parameterAveragingMasterExportTimesMs).hashCode());
        List<EventStats> $parameterAveragingMasterCountRddSizeTimesMs = this.getParameterAveragingMasterCountRddSizeTimesMs();
        result = result * 59 + ($parameterAveragingMasterCountRddSizeTimesMs == null ? 43 : ((Object)$parameterAveragingMasterCountRddSizeTimesMs).hashCode());
        List<EventStats> $parameterAveragingMasterBroadcastCreateTimesMs = this.getParameterAveragingMasterBroadcastCreateTimesMs();
        result = result * 59 + ($parameterAveragingMasterBroadcastCreateTimesMs == null ? 43 : ((Object)$parameterAveragingMasterBroadcastCreateTimesMs).hashCode());
        List<EventStats> $parameterAveragingMasterFitTimesMs = this.getParameterAveragingMasterFitTimesMs();
        result = result * 59 + ($parameterAveragingMasterFitTimesMs == null ? 43 : ((Object)$parameterAveragingMasterFitTimesMs).hashCode());
        List<EventStats> $parameterAveragingMasterSplitTimesMs = this.getParameterAveragingMasterSplitTimesMs();
        result = result * 59 + ($parameterAveragingMasterSplitTimesMs == null ? 43 : ((Object)$parameterAveragingMasterSplitTimesMs).hashCode());
        List<EventStats> $parameterAveragingMasterMapPartitionsTimesMs = this.getParameterAveragingMasterMapPartitionsTimesMs();
        result = result * 59 + ($parameterAveragingMasterMapPartitionsTimesMs == null ? 43 : ((Object)$parameterAveragingMasterMapPartitionsTimesMs).hashCode());
        List<EventStats> $paramaterAveragingMasterAggregateTimesMs = this.getParamaterAveragingMasterAggregateTimesMs();
        result = result * 59 + ($paramaterAveragingMasterAggregateTimesMs == null ? 43 : ((Object)$paramaterAveragingMasterAggregateTimesMs).hashCode());
        List<EventStats> $parameterAveragingMasterProcessParamsUpdaterTimesMs = this.getParameterAveragingMasterProcessParamsUpdaterTimesMs();
        result = result * 59 + ($parameterAveragingMasterProcessParamsUpdaterTimesMs == null ? 43 : ((Object)$parameterAveragingMasterProcessParamsUpdaterTimesMs).hashCode());
        List<EventStats> $parameterAveragingMasterRepartitionTimesMs = this.getParameterAveragingMasterRepartitionTimesMs();
        result = result * 59 + ($parameterAveragingMasterRepartitionTimesMs == null ? 43 : ((Object)$parameterAveragingMasterRepartitionTimesMs).hashCode());
        return result;
    }

    public String toString() {
        return "ParameterAveragingTrainingMasterStats(workerStats=" + this.getWorkerStats() + ", parameterAveragingMasterExportTimesMs=" + this.getParameterAveragingMasterExportTimesMs() + ", parameterAveragingMasterCountRddSizeTimesMs=" + this.getParameterAveragingMasterCountRddSizeTimesMs() + ", parameterAveragingMasterBroadcastCreateTimesMs=" + this.getParameterAveragingMasterBroadcastCreateTimesMs() + ", parameterAveragingMasterFitTimesMs=" + this.getParameterAveragingMasterFitTimesMs() + ", parameterAveragingMasterSplitTimesMs=" + this.getParameterAveragingMasterSplitTimesMs() + ", parameterAveragingMasterMapPartitionsTimesMs=" + this.getParameterAveragingMasterMapPartitionsTimesMs() + ", paramaterAveragingMasterAggregateTimesMs=" + this.getParamaterAveragingMasterAggregateTimesMs() + ", parameterAveragingMasterProcessParamsUpdaterTimesMs=" + this.getParameterAveragingMasterProcessParamsUpdaterTimesMs() + ", parameterAveragingMasterRepartitionTimesMs=" + this.getParameterAveragingMasterRepartitionTimesMs() + ")";
    }

    public static class ParameterAveragingTrainingMasterStatsHelper {
        private long lastExportStartTime;
        private long lastCountStartTime;
        private long lastBroadcastStartTime;
        private long lastRepartitionStartTime;
        private long lastFitStartTime;
        private long lastSplitStartTime;
        private long lastMapPartitionsStartTime;
        private long lastAggregateStartTime;
        private long lastProcessParamsUpdaterStartTime;
        private SparkTrainingStats workerStats;
        private List<EventStats> exportTimes = new ArrayList<EventStats>();
        private List<EventStats> countTimes = new ArrayList<EventStats>();
        private List<EventStats> broadcastTimes = new ArrayList<EventStats>();
        private List<EventStats> repartitionTimes = new ArrayList<EventStats>();
        private List<EventStats> fitTimes = new ArrayList<EventStats>();
        private List<EventStats> splitTimes = new ArrayList<EventStats>();
        private List<EventStats> mapPartitions = new ArrayList<EventStats>();
        private List<EventStats> aggregateTimes = new ArrayList<EventStats>();
        private List<EventStats> processParamsUpdaterTimes = new ArrayList<EventStats>();
        private final TimeSource timeSource = TimeSourceProvider.getInstance();

        public void logExportStart() {
            this.lastExportStartTime = this.timeSource.currentTimeMillis();
        }

        public void logExportEnd() {
            long now = this.timeSource.currentTimeMillis();
            this.exportTimes.add(new BaseEventStats(this.lastExportStartTime, now - this.lastExportStartTime));
        }

        public void logCountStart() {
            this.lastCountStartTime = this.timeSource.currentTimeMillis();
        }

        public void logCountEnd() {
            long now = this.timeSource.currentTimeMillis();
            this.countTimes.add(new BaseEventStats(this.lastCountStartTime, now - this.lastCountStartTime));
        }

        public void logBroadcastStart() {
            this.lastBroadcastStartTime = this.timeSource.currentTimeMillis();
        }

        public void logBroadcastEnd() {
            long now = this.timeSource.currentTimeMillis();
            this.broadcastTimes.add(new BaseEventStats(this.lastBroadcastStartTime, now - this.lastBroadcastStartTime));
        }

        public void logRepartitionStart() {
            this.lastRepartitionStartTime = this.timeSource.currentTimeMillis();
        }

        public void logRepartitionEnd() {
            long now = this.timeSource.currentTimeMillis();
            this.repartitionTimes.add(new BaseEventStats(this.lastRepartitionStartTime, now - this.lastRepartitionStartTime));
        }

        public void logFitStart() {
            this.lastFitStartTime = this.timeSource.currentTimeMillis();
        }

        public void logFitEnd(int examplesCount) {
            long now = this.timeSource.currentTimeMillis();
            this.fitTimes.add(new ExampleCountEventStats(this.lastFitStartTime, now - this.lastFitStartTime, examplesCount));
        }

        public void logSplitStart() {
            this.lastSplitStartTime = this.timeSource.currentTimeMillis();
        }

        public void logSplitEnd() {
            long now = this.timeSource.currentTimeMillis();
            this.splitTimes.add(new BaseEventStats(this.lastSplitStartTime, now - this.lastSplitStartTime));
        }

        public void logMapPartitionsStart() {
            this.lastMapPartitionsStartTime = this.timeSource.currentTimeMillis();
        }

        public void logMapPartitionsEnd(int nPartitions) {
            long now = this.timeSource.currentTimeMillis();
            this.mapPartitions.add(new PartitionCountEventStats(this.lastMapPartitionsStartTime, now - this.lastMapPartitionsStartTime, nPartitions));
        }

        public void logAggregateStartTime() {
            this.lastAggregateStartTime = this.timeSource.currentTimeMillis();
        }

        public void logAggregationEndTime() {
            long now = this.timeSource.currentTimeMillis();
            this.aggregateTimes.add(new BaseEventStats(this.lastAggregateStartTime, now - this.lastAggregateStartTime));
        }

        public void logProcessParamsUpdaterStart() {
            this.lastProcessParamsUpdaterStartTime = this.timeSource.currentTimeMillis();
        }

        public void logProcessParamsUpdaterEnd() {
            long now = this.timeSource.currentTimeMillis();
            this.processParamsUpdaterTimes.add(new BaseEventStats(this.lastProcessParamsUpdaterStartTime, now - this.lastProcessParamsUpdaterStartTime));
        }

        public void addWorkerStats(SparkTrainingStats workerStats) {
            if (this.workerStats == null) {
                this.workerStats = workerStats;
            } else if (workerStats != null) {
                this.workerStats.addOtherTrainingStats(workerStats);
            }
        }

        public ParameterAveragingTrainingMasterStats build() {
            return new ParameterAveragingTrainingMasterStats(this.workerStats, this.exportTimes, this.countTimes, this.broadcastTimes, this.fitTimes, this.splitTimes, this.mapPartitions, this.aggregateTimes, this.processParamsUpdaterTimes, this.repartitionTimes);
        }
    }
}

