/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.datavec;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.spark.api.java.function.PairFunction;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.FeatureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class DataVecByteDataSetFunction
implements PairFunction<Tuple2<Text, BytesWritable>, Double, org.nd4j.linalg.dataset.DataSet> {
    private static final Logger log = LoggerFactory.getLogger(DataVecByteDataSetFunction.class);
    private int labelIndex = 0;
    private int numPossibleLabels;
    private int byteFileLen;
    private int batchSize;
    private int numExamples;
    private boolean regression = false;
    private DataSetPreProcessor preProcessor;

    public DataVecByteDataSetFunction(int labelIndex, int numPossibleLabels, int batchSize, int byteFileLen) {
        this(labelIndex, numPossibleLabels, batchSize, byteFileLen, false, null);
    }

    public DataVecByteDataSetFunction(int labelIndex, int numPossibleLabels, int batchSize, int byteFileLen, boolean regression) {
        this(labelIndex, numPossibleLabels, batchSize, byteFileLen, regression, null);
    }

    public DataVecByteDataSetFunction(int labelIndex, int numPossibleLabels, int batchSize, int byteFileLen, boolean regression, DataSetPreProcessor preProcessor) {
        this.labelIndex = labelIndex;
        this.numPossibleLabels = numPossibleLabels;
        this.batchSize = batchSize;
        this.byteFileLen = byteFileLen;
        this.regression = regression;
        this.preProcessor = preProcessor;
    }

    public Tuple2<Double, org.nd4j.linalg.dataset.DataSet> call(Tuple2<Text, BytesWritable> inputTuple) throws Exception {
        int batchNumCount;
        int lenFeatureVector = 0;
        if (this.numPossibleLabels >= 1) {
            lenFeatureVector = this.byteFileLen - 1;
            if (this.labelIndex < 0) {
                this.labelIndex = this.byteFileLen - 1;
            }
        }
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(((BytesWritable)inputTuple._2()).getBytes()));
        byte[] byteFeature = new byte[this.byteFileLen];
        ArrayList<org.nd4j.linalg.dataset.DataSet> dataSets = new ArrayList<org.nd4j.linalg.dataset.DataSet>();
        try {
            INDArray featureVector = Nd4j.create((int)lenFeatureVector);
            for (batchNumCount = 0; ((InputStream)inputStream).read(byteFeature) != -1 && batchNumCount != this.batchSize; ++batchNumCount) {
                int featureCount = 0;
                INDArray label = FeatureUtil.toOutcomeVector((long)byteFeature[this.labelIndex], (long)this.numPossibleLabels);
                int j = 1;
                while ((long)j <= featureVector.length()) {
                    featureVector.putScalar((long)featureCount++, (int)byteFeature[j]);
                    ++j;
                }
                dataSets.add(new org.nd4j.linalg.dataset.DataSet(featureVector, label));
                byteFeature = new byte[this.byteFileLen];
                featureVector = Nd4j.create((int)lenFeatureVector);
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        ArrayList<INDArray> inputs = new ArrayList<INDArray>();
        ArrayList<INDArray> labels = new ArrayList<INDArray>();
        for (org.nd4j.linalg.dataset.DataSet data : dataSets) {
            inputs.add(data.getFeatures());
            labels.add(data.getLabels());
        }
        org.nd4j.linalg.dataset.DataSet ds = new org.nd4j.linalg.dataset.DataSet(Nd4j.vstack((INDArray[])inputs.toArray(new INDArray[0])), Nd4j.vstack((INDArray[])labels.toArray(new INDArray[0])));
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)ds);
        }
        return new Tuple2((Object)batchNumCount, (Object)ds);
    }
}

