/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.data;

import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.broadcast.Broadcast;
import org.datavec.spark.util.DefaultHadoopConfig;
import org.datavec.spark.util.SerializableHadoopConfig;
import org.deeplearning4j.core.util.UIDProvider;
import org.nd4j.linalg.dataset.api.MultiDataSet;

public class MultiDataSetExportFunction
implements VoidFunction<Iterator<MultiDataSet>> {
    private final URI outputDir;
    private final Broadcast<SerializableHadoopConfig> conf;
    private String uid = null;
    private int outputCount;

    public MultiDataSetExportFunction(URI outputDir) {
        this(outputDir, null);
    }

    public MultiDataSetExportFunction(URI outputDir, Broadcast<SerializableHadoopConfig> configuration) {
        this.outputDir = outputDir;
        this.conf = configuration;
    }

    public void call(Iterator<MultiDataSet> iter) throws Exception {
        Configuration c;
        String jvmuid = UIDProvider.getJVMUID();
        this.uid = Thread.currentThread().getId() + jvmuid.substring(0, Math.min(8, jvmuid.length()));
        Configuration configuration = c = this.conf == null ? DefaultHadoopConfig.get() : ((SerializableHadoopConfig)this.conf.getValue()).getConfiguration();
        while (iter.hasNext()) {
            String path;
            MultiDataSet next = iter.next();
            String filename = "mds_" + this.uid + "_" + this.outputCount++ + ".bin";
            URI uri = new URI(path + ((path = this.outputDir.getPath()).endsWith("/") || path.endsWith("\\") ? "" : "/") + filename);
            FileSystem file = FileSystem.get((URI)uri, (Configuration)c);
            FSDataOutputStream out = file.create(new Path(uri));
            try {
                next.save((OutputStream)out);
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }
}

