/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.api.worker;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.datavec.spark.util.SerializableHadoopConfig;
import org.deeplearning4j.core.loader.DataSetLoader;
import org.deeplearning4j.spark.api.TrainingResult;
import org.deeplearning4j.spark.api.TrainingWorker;
import org.deeplearning4j.spark.api.WorkerConfiguration;
import org.deeplearning4j.spark.api.worker.ExecuteWorkerFlatMap;
import org.deeplearning4j.spark.iterator.PathSparkDataSetIterator;
import org.nd4j.linalg.dataset.DataSet;

public class ExecuteWorkerPathFlatMap<R extends TrainingResult>
implements FlatMapFunction<Iterator<String>, R> {
    private final FlatMapFunction<Iterator<DataSet>, R> workerFlatMap;
    private final DataSetLoader dataSetLoader;
    private final int maxDataSetObjects;
    private final Broadcast<SerializableHadoopConfig> hadoopConfig;

    public ExecuteWorkerPathFlatMap(TrainingWorker<R> worker, DataSetLoader dataSetLoader, Broadcast<SerializableHadoopConfig> hadoopConfig) {
        this.workerFlatMap = new ExecuteWorkerFlatMap<R>(worker);
        this.dataSetLoader = dataSetLoader;
        this.hadoopConfig = hadoopConfig;
        WorkerConfiguration conf = worker.getDataConfiguration();
        int dataSetObjectNumExamples = conf.getDataSetObjectSizeExamples();
        int workerMinibatchSize = conf.getBatchSizePerWorker();
        int maxMinibatches = conf.getMaxBatchesPerWorker() > 0 ? conf.getMaxBatchesPerWorker() : Integer.MAX_VALUE;
        this.maxDataSetObjects = maxMinibatches == Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.ceil((double)(maxMinibatches * workerMinibatchSize) / (double)dataSetObjectNumExamples);
    }

    public Iterator<R> call(Iterator<String> iter) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        int count = 0;
        while (iter.hasNext() && count++ < this.maxDataSetObjects) {
            list.add(iter.next());
        }
        return this.workerFlatMap.call((Object)new PathSparkDataSetIterator(list.iterator(), this.dataSetLoader, this.hadoopConfig));
    }
}

