/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.api.stats;

import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.spark.api.stats.CommonSparkTrainingStats;
import org.deeplearning4j.spark.api.stats.SparkTrainingStats;
import org.deeplearning4j.spark.stats.BaseEventStats;
import org.deeplearning4j.spark.stats.EventStats;
import org.deeplearning4j.spark.stats.ExampleCountEventStats;
import org.deeplearning4j.spark.time.TimeSource;
import org.deeplearning4j.spark.time.TimeSourceProvider;

public class StatsCalculationHelper {
    private long methodStartTime;
    private long returnTime;
    private long initalModelBefore;
    private long initialModelAfter;
    private long lastDataSetBefore;
    private long lastProcessBefore;
    private long totalExampleCount;
    private List<EventStats> dataSetGetTimes = new ArrayList<EventStats>();
    private List<EventStats> processMiniBatchTimes = new ArrayList<EventStats>();
    private TimeSource timeSource = TimeSourceProvider.getInstance();

    public void logMethodStartTime() {
        this.methodStartTime = this.timeSource.currentTimeMillis();
    }

    public void logReturnTime() {
        this.returnTime = this.timeSource.currentTimeMillis();
    }

    public void logInitialModelBefore() {
        this.initalModelBefore = this.timeSource.currentTimeMillis();
    }

    public void logInitialModelAfter() {
        this.initialModelAfter = this.timeSource.currentTimeMillis();
    }

    public void logNextDataSetBefore() {
        this.lastDataSetBefore = this.timeSource.currentTimeMillis();
    }

    public void logNextDataSetAfter(long numExamples) {
        long now = this.timeSource.currentTimeMillis();
        long duration = now - this.lastDataSetBefore;
        this.dataSetGetTimes.add(new BaseEventStats(this.lastDataSetBefore, duration));
        this.totalExampleCount += numExamples;
    }

    public void logProcessMinibatchBefore() {
        this.lastProcessBefore = this.timeSource.currentTimeMillis();
    }

    public void logProcessMinibatchAfter() {
        long now = this.timeSource.currentTimeMillis();
        long duration = now - this.lastProcessBefore;
        this.processMiniBatchTimes.add(new BaseEventStats(this.lastProcessBefore, duration));
    }

    public CommonSparkTrainingStats build(SparkTrainingStats masterSpecificStats) {
        ArrayList<EventStats> totalTime = new ArrayList<EventStats>();
        totalTime.add(new ExampleCountEventStats(this.methodStartTime, this.returnTime - this.methodStartTime, this.totalExampleCount));
        ArrayList<EventStats> initTime = new ArrayList<EventStats>();
        initTime.add(new BaseEventStats(this.initalModelBefore, this.initialModelAfter - this.initalModelBefore));
        return new CommonSparkTrainingStats.Builder().trainingMasterSpecificStats(masterSpecificStats).workerFlatMapTotalTimeMs(totalTime).workerFlatMapGetInitialModelTimeMs(initTime).workerFlatMapDataSetGetTimesMs(this.dataSetGetTimes).workerFlatMapProcessMiniBatchTimesMs(this.processMiniBatchTimes).build();
    }
}

