/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.api.stats;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.spark.SparkContext;
import org.deeplearning4j.spark.api.stats.SparkTrainingStats;
import org.deeplearning4j.spark.stats.EventStats;
import org.deeplearning4j.spark.stats.StatsUtils;

public class CommonSparkTrainingStats
implements SparkTrainingStats {
    public static final String DEFAULT_DELIMITER = ",";
    public static final String FILENAME_TOTAL_TIME_STATS = "workerFlatMapTotalTimeMs.txt";
    public static final String FILENAME_GET_INITIAL_MODEL_STATS = "workerFlatMapGetInitialModelTimeMs.txt";
    public static final String FILENAME_DATASET_GET_TIME_STATS = "workerFlatMapDataSetGetTimesMs.txt";
    public static final String FILENAME_PROCESS_MINIBATCH_TIME_STATS = "workerFlatMapProcessMiniBatchTimesMs.txt";
    public static final String WORKER_FLAT_MAP_TOTAL_TIME_MS = "WorkerFlatMapTotalTimeMs";
    public static final String WORKER_FLAT_MAP_GET_INITIAL_MODEL_TIME_MS = "WorkerFlatMapGetInitialModelTimeMs";
    public static final String WORKER_FLAT_MAP_DATA_SET_GET_TIMES_MS = "WorkerFlatMapDataSetGetTimesMs";
    public static final String WORKER_FLAT_MAP_PROCESS_MINI_BATCH_TIMES_MS = "WorkerFlatMapProcessMiniBatchTimesMs";
    private static Set<String> columnNames = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("WorkerFlatMapTotalTimeMs", "WorkerFlatMapGetInitialModelTimeMs", "WorkerFlatMapDataSetGetTimesMs", "WorkerFlatMapProcessMiniBatchTimesMs")));
    private SparkTrainingStats trainingWorkerSpecificStats;
    private List<EventStats> workerFlatMapTotalTimeMs;
    private List<EventStats> workerFlatMapGetInitialModelTimeMs;
    private List<EventStats> workerFlatMapDataSetGetTimesMs;
    private List<EventStats> workerFlatMapProcessMiniBatchTimesMs;

    public CommonSparkTrainingStats() {
    }

    private CommonSparkTrainingStats(Builder builder) {
        this.trainingWorkerSpecificStats = builder.trainingMasterSpecificStats;
        this.workerFlatMapTotalTimeMs = builder.workerFlatMapTotalTimeMs;
        this.workerFlatMapGetInitialModelTimeMs = builder.workerFlatMapGetInitialModelTimeMs;
        this.workerFlatMapDataSetGetTimesMs = builder.workerFlatMapDataSetGetTimesMs;
        this.workerFlatMapProcessMiniBatchTimesMs = builder.workerFlatMapProcessMiniBatchTimesMs;
    }

    @Override
    public Set<String> getKeySet() {
        LinkedHashSet<String> set = new LinkedHashSet<String>(columnNames);
        if (this.trainingWorkerSpecificStats != null) {
            set.addAll(this.trainingWorkerSpecificStats.getKeySet());
        }
        return set;
    }

    @Override
    public List<EventStats> getValue(String key) {
        switch (key) {
            case "WorkerFlatMapTotalTimeMs": {
                return this.workerFlatMapTotalTimeMs;
            }
            case "WorkerFlatMapGetInitialModelTimeMs": {
                return this.workerFlatMapGetInitialModelTimeMs;
            }
            case "WorkerFlatMapDataSetGetTimesMs": {
                return this.workerFlatMapDataSetGetTimesMs;
            }
            case "WorkerFlatMapProcessMiniBatchTimesMs": {
                return this.workerFlatMapProcessMiniBatchTimesMs;
            }
        }
        if (this.trainingWorkerSpecificStats != null) {
            return this.trainingWorkerSpecificStats.getValue(key);
        }
        throw new IllegalArgumentException("Unknown key: \"" + key + "\"");
    }

    @Override
    public String getShortNameForKey(String key) {
        switch (key) {
            case "WorkerFlatMapTotalTimeMs": {
                return "Total";
            }
            case "WorkerFlatMapGetInitialModelTimeMs": {
                return "GetInitModel";
            }
            case "WorkerFlatMapDataSetGetTimesMs": {
                return "GetDataSet";
            }
            case "WorkerFlatMapProcessMiniBatchTimesMs": {
                return "ProcessBatch";
            }
        }
        if (this.trainingWorkerSpecificStats != null) {
            return this.trainingWorkerSpecificStats.getShortNameForKey(key);
        }
        throw new IllegalArgumentException("Unknown key: \"" + key + "\"");
    }

    @Override
    public boolean defaultIncludeInPlots(String key) {
        switch (key) {
            case "WorkerFlatMapTotalTimeMs": 
            case "WorkerFlatMapGetInitialModelTimeMs": 
            case "WorkerFlatMapProcessMiniBatchTimesMs": {
                return false;
            }
            case "WorkerFlatMapDataSetGetTimesMs": {
                return true;
            }
        }
        if (this.trainingWorkerSpecificStats != null) {
            return this.trainingWorkerSpecificStats.defaultIncludeInPlots(key);
        }
        return false;
    }

    @Override
    public void addOtherTrainingStats(SparkTrainingStats other) {
        if (!(other instanceof CommonSparkTrainingStats)) {
            throw new IllegalArgumentException("Cannot add other training stats: not an instance of CommonSparkTrainingStats");
        }
        CommonSparkTrainingStats o = (CommonSparkTrainingStats)other;
        this.workerFlatMapTotalTimeMs.addAll(o.workerFlatMapTotalTimeMs);
        this.workerFlatMapGetInitialModelTimeMs.addAll(o.workerFlatMapGetInitialModelTimeMs);
        this.workerFlatMapDataSetGetTimesMs.addAll(o.workerFlatMapDataSetGetTimesMs);
        this.workerFlatMapProcessMiniBatchTimesMs.addAll(o.workerFlatMapProcessMiniBatchTimesMs);
        if (this.trainingWorkerSpecificStats != null) {
            this.trainingWorkerSpecificStats.addOtherTrainingStats(o.trainingWorkerSpecificStats);
        } else if (o.trainingWorkerSpecificStats != null) {
            throw new IllegalStateException("Cannot merge: training master specific stats is null in one, but not the other");
        }
    }

    @Override
    public SparkTrainingStats getNestedTrainingStats() {
        return this.trainingWorkerSpecificStats;
    }

    @Override
    public String statsAsString() {
        StringBuilder sb = new StringBuilder();
        String f = "%-55s";
        sb.append(String.format(f, WORKER_FLAT_MAP_TOTAL_TIME_MS));
        if (this.workerFlatMapTotalTimeMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.workerFlatMapTotalTimeMs, DEFAULT_DELIMITER)).append("\n");
        }
        sb.append(String.format(f, WORKER_FLAT_MAP_GET_INITIAL_MODEL_TIME_MS));
        if (this.workerFlatMapGetInitialModelTimeMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.workerFlatMapGetInitialModelTimeMs, DEFAULT_DELIMITER)).append("\n");
        }
        sb.append(String.format(f, WORKER_FLAT_MAP_DATA_SET_GET_TIMES_MS));
        if (this.workerFlatMapDataSetGetTimesMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.workerFlatMapDataSetGetTimesMs, DEFAULT_DELIMITER)).append("\n");
        }
        sb.append(String.format(f, WORKER_FLAT_MAP_PROCESS_MINI_BATCH_TIMES_MS));
        if (this.workerFlatMapProcessMiniBatchTimesMs == null) {
            sb.append("-\n");
        } else {
            sb.append(StatsUtils.getDurationAsString(this.workerFlatMapProcessMiniBatchTimesMs, DEFAULT_DELIMITER)).append("\n");
        }
        if (this.trainingWorkerSpecificStats != null) {
            sb.append(this.trainingWorkerSpecificStats.statsAsString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void exportStatFiles(String outputPath, SparkContext sc) throws IOException {
        String d = DEFAULT_DELIMITER;
        String totalTimeStatsPath = FilenameUtils.concat((String)outputPath, (String)FILENAME_TOTAL_TIME_STATS);
        StatsUtils.exportStats(this.workerFlatMapTotalTimeMs, totalTimeStatsPath, d, sc);
        String getInitialModelStatsPath = FilenameUtils.concat((String)outputPath, (String)FILENAME_GET_INITIAL_MODEL_STATS);
        StatsUtils.exportStats(this.workerFlatMapGetInitialModelTimeMs, getInitialModelStatsPath, d, sc);
        String getDataSetStatsPath = FilenameUtils.concat((String)outputPath, (String)FILENAME_DATASET_GET_TIME_STATS);
        StatsUtils.exportStats(this.workerFlatMapDataSetGetTimesMs, getDataSetStatsPath, d, sc);
        String processMiniBatchStatsPath = FilenameUtils.concat((String)outputPath, (String)FILENAME_PROCESS_MINIBATCH_TIME_STATS);
        StatsUtils.exportStats(this.workerFlatMapProcessMiniBatchTimesMs, processMiniBatchStatsPath, d, sc);
        if (this.trainingWorkerSpecificStats != null) {
            this.trainingWorkerSpecificStats.exportStatFiles(outputPath, sc);
        }
    }

    public SparkTrainingStats getTrainingWorkerSpecificStats() {
        return this.trainingWorkerSpecificStats;
    }

    public List<EventStats> getWorkerFlatMapTotalTimeMs() {
        return this.workerFlatMapTotalTimeMs;
    }

    public List<EventStats> getWorkerFlatMapGetInitialModelTimeMs() {
        return this.workerFlatMapGetInitialModelTimeMs;
    }

    public List<EventStats> getWorkerFlatMapDataSetGetTimesMs() {
        return this.workerFlatMapDataSetGetTimesMs;
    }

    public List<EventStats> getWorkerFlatMapProcessMiniBatchTimesMs() {
        return this.workerFlatMapProcessMiniBatchTimesMs;
    }

    public void setTrainingWorkerSpecificStats(SparkTrainingStats trainingWorkerSpecificStats) {
        this.trainingWorkerSpecificStats = trainingWorkerSpecificStats;
    }

    public void setWorkerFlatMapTotalTimeMs(List<EventStats> workerFlatMapTotalTimeMs) {
        this.workerFlatMapTotalTimeMs = workerFlatMapTotalTimeMs;
    }

    public void setWorkerFlatMapGetInitialModelTimeMs(List<EventStats> workerFlatMapGetInitialModelTimeMs) {
        this.workerFlatMapGetInitialModelTimeMs = workerFlatMapGetInitialModelTimeMs;
    }

    public void setWorkerFlatMapDataSetGetTimesMs(List<EventStats> workerFlatMapDataSetGetTimesMs) {
        this.workerFlatMapDataSetGetTimesMs = workerFlatMapDataSetGetTimesMs;
    }

    public void setWorkerFlatMapProcessMiniBatchTimesMs(List<EventStats> workerFlatMapProcessMiniBatchTimesMs) {
        this.workerFlatMapProcessMiniBatchTimesMs = workerFlatMapProcessMiniBatchTimesMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonSparkTrainingStats)) {
            return false;
        }
        CommonSparkTrainingStats other = (CommonSparkTrainingStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SparkTrainingStats this$trainingWorkerSpecificStats = this.getTrainingWorkerSpecificStats();
        SparkTrainingStats other$trainingWorkerSpecificStats = other.getTrainingWorkerSpecificStats();
        if (this$trainingWorkerSpecificStats == null ? other$trainingWorkerSpecificStats != null : !this$trainingWorkerSpecificStats.equals(other$trainingWorkerSpecificStats)) {
            return false;
        }
        List<EventStats> this$workerFlatMapTotalTimeMs = this.getWorkerFlatMapTotalTimeMs();
        List<EventStats> other$workerFlatMapTotalTimeMs = other.getWorkerFlatMapTotalTimeMs();
        if (this$workerFlatMapTotalTimeMs == null ? other$workerFlatMapTotalTimeMs != null : !((Object)this$workerFlatMapTotalTimeMs).equals(other$workerFlatMapTotalTimeMs)) {
            return false;
        }
        List<EventStats> this$workerFlatMapGetInitialModelTimeMs = this.getWorkerFlatMapGetInitialModelTimeMs();
        List<EventStats> other$workerFlatMapGetInitialModelTimeMs = other.getWorkerFlatMapGetInitialModelTimeMs();
        if (this$workerFlatMapGetInitialModelTimeMs == null ? other$workerFlatMapGetInitialModelTimeMs != null : !((Object)this$workerFlatMapGetInitialModelTimeMs).equals(other$workerFlatMapGetInitialModelTimeMs)) {
            return false;
        }
        List<EventStats> this$workerFlatMapDataSetGetTimesMs = this.getWorkerFlatMapDataSetGetTimesMs();
        List<EventStats> other$workerFlatMapDataSetGetTimesMs = other.getWorkerFlatMapDataSetGetTimesMs();
        if (this$workerFlatMapDataSetGetTimesMs == null ? other$workerFlatMapDataSetGetTimesMs != null : !((Object)this$workerFlatMapDataSetGetTimesMs).equals(other$workerFlatMapDataSetGetTimesMs)) {
            return false;
        }
        List<EventStats> this$workerFlatMapProcessMiniBatchTimesMs = this.getWorkerFlatMapProcessMiniBatchTimesMs();
        List<EventStats> other$workerFlatMapProcessMiniBatchTimesMs = other.getWorkerFlatMapProcessMiniBatchTimesMs();
        return !(this$workerFlatMapProcessMiniBatchTimesMs == null ? other$workerFlatMapProcessMiniBatchTimesMs != null : !((Object)this$workerFlatMapProcessMiniBatchTimesMs).equals(other$workerFlatMapProcessMiniBatchTimesMs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonSparkTrainingStats;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SparkTrainingStats $trainingWorkerSpecificStats = this.getTrainingWorkerSpecificStats();
        result = result * 59 + ($trainingWorkerSpecificStats == null ? 43 : $trainingWorkerSpecificStats.hashCode());
        List<EventStats> $workerFlatMapTotalTimeMs = this.getWorkerFlatMapTotalTimeMs();
        result = result * 59 + ($workerFlatMapTotalTimeMs == null ? 43 : ((Object)$workerFlatMapTotalTimeMs).hashCode());
        List<EventStats> $workerFlatMapGetInitialModelTimeMs = this.getWorkerFlatMapGetInitialModelTimeMs();
        result = result * 59 + ($workerFlatMapGetInitialModelTimeMs == null ? 43 : ((Object)$workerFlatMapGetInitialModelTimeMs).hashCode());
        List<EventStats> $workerFlatMapDataSetGetTimesMs = this.getWorkerFlatMapDataSetGetTimesMs();
        result = result * 59 + ($workerFlatMapDataSetGetTimesMs == null ? 43 : ((Object)$workerFlatMapDataSetGetTimesMs).hashCode());
        List<EventStats> $workerFlatMapProcessMiniBatchTimesMs = this.getWorkerFlatMapProcessMiniBatchTimesMs();
        result = result * 59 + ($workerFlatMapProcessMiniBatchTimesMs == null ? 43 : ((Object)$workerFlatMapProcessMiniBatchTimesMs).hashCode());
        return result;
    }

    public String toString() {
        return "CommonSparkTrainingStats(trainingWorkerSpecificStats=" + this.getTrainingWorkerSpecificStats() + ", workerFlatMapTotalTimeMs=" + this.getWorkerFlatMapTotalTimeMs() + ", workerFlatMapGetInitialModelTimeMs=" + this.getWorkerFlatMapGetInitialModelTimeMs() + ", workerFlatMapDataSetGetTimesMs=" + this.getWorkerFlatMapDataSetGetTimesMs() + ", workerFlatMapProcessMiniBatchTimesMs=" + this.getWorkerFlatMapProcessMiniBatchTimesMs() + ")";
    }

    public static class Builder {
        private SparkTrainingStats trainingMasterSpecificStats;
        private List<EventStats> workerFlatMapTotalTimeMs;
        private List<EventStats> workerFlatMapGetInitialModelTimeMs;
        private List<EventStats> workerFlatMapDataSetGetTimesMs;
        private List<EventStats> workerFlatMapProcessMiniBatchTimesMs;

        public Builder trainingMasterSpecificStats(SparkTrainingStats trainingMasterSpecificStats) {
            this.trainingMasterSpecificStats = trainingMasterSpecificStats;
            return this;
        }

        public Builder workerFlatMapTotalTimeMs(List<EventStats> workerFlatMapTotalTimeMs) {
            this.workerFlatMapTotalTimeMs = workerFlatMapTotalTimeMs;
            return this;
        }

        public Builder workerFlatMapGetInitialModelTimeMs(List<EventStats> workerFlatMapGetInitialModelTimeMs) {
            this.workerFlatMapGetInitialModelTimeMs = workerFlatMapGetInitialModelTimeMs;
            return this;
        }

        public Builder workerFlatMapDataSetGetTimesMs(List<EventStats> workerFlatMapDataSetGetTimesMs) {
            this.workerFlatMapDataSetGetTimesMs = workerFlatMapDataSetGetTimesMs;
            return this;
        }

        public Builder workerFlatMapProcessMiniBatchTimesMs(List<EventStats> workerFlatMapProcessMiniBatchTimesMs) {
            this.workerFlatMapProcessMiniBatchTimesMs = workerFlatMapProcessMiniBatchTimesMs;
            return this;
        }

        public CommonSparkTrainingStats build() {
            return new CommonSparkTrainingStats(this);
        }
    }
}

