/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.subsampling;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.Convolution3DUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subsampling3DLayer
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.Subsampling3DLayer> {
    private static final Logger log = LoggerFactory.getLogger(Subsampling3DLayer.class);
    protected ConvolutionMode convolutionMode;

    public Subsampling3DLayer(NeuralNetConfiguration conf) {
        super(conf);
        this.convolutionMode = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)conf.getLayer()).getConvolutionMode();
    }

    public Subsampling3DLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.SUBSAMPLING;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        int[] pad;
        this.assertInputSet(true);
        int miniBatch = (int)this.input.size(0);
        int inChannels = (int)this.input.size(1);
        int inD = (int)this.input.size(2);
        int inH = (int)this.input.size(3);
        int inW = (int)this.input.size(4);
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getStride();
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getDilation();
        if (this.convolutionMode == ConvolutionMode.Same) {
            int[] outSize = Convolution3DUtils.get3DOutputSize(this.input, kernel, strides, null, this.convolutionMode, dilation, true);
            pad = Convolution3DUtils.get3DSameModeTopLeftPadding(outSize, new int[]{inD, inH, inW}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getPadding();
        }
        INDArray outEpsilon = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, new long[]{miniBatch * inChannels * inD * inH * inW});
        outEpsilon = outEpsilon.reshape('c', new int[]{miniBatch, inChannels, inD, inH, inW});
        int[] intArgs = new int[]{kernel[0], kernel[1], kernel[2], strides[0], strides[1], strides[2], pad[0], pad[1], pad[2], dilation[0], dilation[1], dilation[2], this.convolutionMode == ConvolutionMode.Same ? 1 : 0, 1};
        String opName = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getPoolingType() == PoolingType.MAX ? "maxpool3dnew_bp" : "avgpool3dnew_bp";
        DynamicCustomOp op = DynamicCustomOp.builder((String)opName).addInputs(new INDArray[]{this.input, epsilon}).addIntegerArguments(intArgs).addOutputs(new INDArray[]{outEpsilon}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        DefaultGradient retGradient = new DefaultGradient();
        outEpsilon = this.backpropDropOutIfPresent(outEpsilon);
        return new Pair((Object)retGradient, (Object)outEpsilon);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        int[] pad;
        int[] outSize;
        this.assertInputSet(false);
        if (training && !this.dropoutApplied && ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getIDropout() != null) {
            this.applyDropOutIfNecessary(true, workspaceMgr);
        }
        if (this.input.rank() != 5) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Subsampling3DLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 5 array with shape [minibatchSize, channels, inputDepth, inputHeight, inputWidth]. " + this.layerId());
        }
        int miniBatch = (int)this.input.size(0);
        int inChannels = (int)this.input.size(1);
        int inD = (int)this.input.size(2);
        int inH = (int)this.input.size(3);
        int inW = (int)this.input.size(4);
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getStride();
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getDilation();
        if (this.convolutionMode == ConvolutionMode.Same) {
            int[] inShape = new int[]{inD, inH, inW};
            outSize = Convolution3DUtils.get3DOutputSize(this.input, kernel, strides, null, this.convolutionMode, dilation, true);
            pad = Convolution3DUtils.get3DSameModeTopLeftPadding(outSize, inShape, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getPadding();
            outSize = Convolution3DUtils.get3DOutputSize(this.input, kernel, strides, pad, this.convolutionMode, dilation, true);
        }
        int outD = outSize[0];
        int outH = outSize[1];
        int outW = outSize[2];
        String opName = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getPoolingType() == PoolingType.MAX ? "maxpool3dnew" : "avgpool3dnew";
        INDArray output = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, new int[]{miniBatch, inChannels, outD, outH, outW}, 'c');
        int[] intArgs = new int[]{kernel[0], kernel[1], kernel[2], strides[0], strides[1], strides[2], pad[0], pad[1], pad[2], dilation[0], dilation[1], dilation[2], this.convolutionMode == ConvolutionMode.Same ? 1 : 0, 0};
        DynamicCustomOp op = DynamicCustomOp.builder((String)opName).addInputs(new INDArray[]{this.input}).addIntegerArguments(intArgs).addOutputs(new INDArray[]{output}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return output;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public void fit() {
    }

    @Override
    public int numParams() {
        return 0;
    }

    @Override
    public void fit(INDArray input, LayerWorkspaceMgr workspaceMgr) {
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }
}

