/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.misc;

import java.util.Collection;
import java.util.List;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.params.FrozenLayerParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class FrozenLayer
extends Layer {
    protected Layer layer;

    private FrozenLayer(Builder builder) {
        super(builder);
        this.layer = builder.layer;
    }

    public FrozenLayer(@JsonProperty(value="layer") Layer layer) {
        this.layer = layer;
    }

    public NeuralNetConfiguration getInnerConf(NeuralNetConfiguration conf) {
        NeuralNetConfiguration nnc = conf.clone();
        nnc.setLayer(this.layer);
        return nnc;
    }

    @Override
    public Layer clone() {
        FrozenLayer l = (FrozenLayer)super.clone();
        l.layer = this.layer.clone();
        return l;
    }

    @Override
    public org.deeplearning4j.nn.api.Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        org.deeplearning4j.nn.api.Layer underlying = this.layer.instantiate(this.getInnerConf(conf), trainingListeners, layerIndex, layerParamsView, initializeParams);
        NeuralNetConfiguration nncUnderlying = underlying.conf();
        if (nncUnderlying.variables() != null) {
            List<String> vars = nncUnderlying.variables(true);
            nncUnderlying.clearVariables();
            conf.clearVariables();
            for (String s : vars) {
                conf.variables(false).add(s);
                nncUnderlying.variables(false).add(s);
            }
        }
        return new org.deeplearning4j.nn.layers.FrozenLayer(underlying);
    }

    @Override
    public ParamInitializer initializer() {
        return FrozenLayerParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        return this.layer.getOutputType(layerIndex, inputType);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        this.layer.setNIn(inputType, override);
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        return this.layer.getPreProcessorForInputType(inputType);
    }

    @Override
    public double getL1ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public double getL2ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        return false;
    }

    @Override
    public IUpdater getUpdaterByParam(String paramName) {
        return null;
    }

    @Override
    public GradientNormalization getGradientNormalization() {
        return this.layer.getGradientNormalization();
    }

    @Override
    public double getGradientNormalizationThreshold() {
        return this.layer.getGradientNormalizationThreshold();
    }

    @Override
    public boolean isPretrain() {
        return this.layer.isPretrain();
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        return this.layer.getMemoryReport(inputType);
    }

    @Override
    public void setLayerName(String layerName) {
        super.setLayerName(layerName);
        this.layer.setLayerName(layerName);
    }

    @Override
    public void setConstraints(List<LayerConstraint> constraints) {
        this.constraints = constraints;
        this.layer.setConstraints(constraints);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FrozenLayer)) {
            return false;
        }
        FrozenLayer other = (FrozenLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Layer this$layer = this.getLayer();
        Layer other$layer = other.getLayer();
        return !(this$layer == null ? other$layer != null : !((Object)this$layer).equals(other$layer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FrozenLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Layer $layer = this.getLayer();
        result = result * 59 + ($layer == null ? 43 : ((Object)$layer).hashCode());
        return result;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public static class Builder
    extends Layer.Builder<Builder> {
        private Layer layer;

        public Builder layer(Layer layer) {
            this.layer = layer;
            return this;
        }

        @Override
        public FrozenLayer build() {
            return new FrozenLayer(this);
        }
    }
}

