/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.weights;

import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.deeplearning4j.nn.weights.WeightInitConstant;
import org.deeplearning4j.nn.weights.WeightInitDistribution;
import org.deeplearning4j.nn.weights.WeightInitIdentity;
import org.deeplearning4j.nn.weights.WeightInitLecunUniform;
import org.deeplearning4j.nn.weights.WeightInitNormal;
import org.deeplearning4j.nn.weights.WeightInitRelu;
import org.deeplearning4j.nn.weights.WeightInitReluUniform;
import org.deeplearning4j.nn.weights.WeightInitSigmoidUniform;
import org.deeplearning4j.nn.weights.WeightInitUniform;
import org.deeplearning4j.nn.weights.WeightInitVarScalingNormalFanAvg;
import org.deeplearning4j.nn.weights.WeightInitVarScalingNormalFanIn;
import org.deeplearning4j.nn.weights.WeightInitVarScalingNormalFanOut;
import org.deeplearning4j.nn.weights.WeightInitVarScalingUniformFanAvg;
import org.deeplearning4j.nn.weights.WeightInitVarScalingUniformFanIn;
import org.deeplearning4j.nn.weights.WeightInitVarScalingUniformFanOut;
import org.deeplearning4j.nn.weights.WeightInitXavier;
import org.deeplearning4j.nn.weights.WeightInitXavierLegacy;
import org.deeplearning4j.nn.weights.WeightInitXavierUniform;

public enum WeightInit {
    DISTRIBUTION,
    ZERO,
    ONES,
    SIGMOID_UNIFORM,
    NORMAL,
    LECUN_NORMAL,
    UNIFORM,
    XAVIER,
    XAVIER_UNIFORM,
    XAVIER_FAN_IN,
    XAVIER_LEGACY,
    RELU,
    RELU_UNIFORM,
    IDENTITY,
    LECUN_UNIFORM,
    VAR_SCALING_NORMAL_FAN_IN,
    VAR_SCALING_NORMAL_FAN_OUT,
    VAR_SCALING_NORMAL_FAN_AVG,
    VAR_SCALING_UNIFORM_FAN_IN,
    VAR_SCALING_UNIFORM_FAN_OUT,
    VAR_SCALING_UNIFORM_FAN_AVG;


    public IWeightInit getWeightInitFunction() {
        return this.getWeightInitFunction(null);
    }

    public IWeightInit getWeightInitFunction(Distribution distribution) {
        switch (this) {
            case ZERO: {
                return new WeightInitConstant(0.0);
            }
            case ONES: {
                return new WeightInitConstant(1.0);
            }
            case DISTRIBUTION: {
                return new WeightInitDistribution(distribution);
            }
            case SIGMOID_UNIFORM: {
                return new WeightInitSigmoidUniform();
            }
            case LECUN_NORMAL: 
            case XAVIER_FAN_IN: 
            case NORMAL: {
                return new WeightInitNormal();
            }
            case UNIFORM: {
                return new WeightInitUniform();
            }
            case XAVIER: {
                return new WeightInitXavier();
            }
            case XAVIER_UNIFORM: {
                return new WeightInitXavierUniform();
            }
            case XAVIER_LEGACY: {
                return new WeightInitXavierLegacy();
            }
            case RELU: {
                return new WeightInitRelu();
            }
            case RELU_UNIFORM: {
                return new WeightInitReluUniform();
            }
            case IDENTITY: {
                return new WeightInitIdentity();
            }
            case LECUN_UNIFORM: {
                return new WeightInitLecunUniform();
            }
            case VAR_SCALING_NORMAL_FAN_IN: {
                return new WeightInitVarScalingNormalFanIn();
            }
            case VAR_SCALING_NORMAL_FAN_OUT: {
                return new WeightInitVarScalingNormalFanOut();
            }
            case VAR_SCALING_NORMAL_FAN_AVG: {
                return new WeightInitVarScalingNormalFanAvg();
            }
            case VAR_SCALING_UNIFORM_FAN_IN: {
                return new WeightInitVarScalingUniformFanIn();
            }
            case VAR_SCALING_UNIFORM_FAN_OUT: {
                return new WeightInitVarScalingUniformFanOut();
            }
            case VAR_SCALING_UNIFORM_FAN_AVG: {
                return new WeightInitVarScalingUniformFanAvg();
            }
        }
        throw new UnsupportedOperationException("Unknown or not supported weight initialization function: " + this);
    }
}

