/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import java.util.Arrays;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.api.TrainingConfig;
import org.deeplearning4j.nn.api.layers.IOutputLayer;
import org.deeplearning4j.nn.api.layers.RecurrentLayer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.deeplearning4j.nn.layers.BaseOutputLayer;
import org.deeplearning4j.nn.layers.FrozenLayer;
import org.deeplearning4j.nn.layers.FrozenLayerWithBackprop;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class LayerVertex
extends BaseGraphVertex {
    private Layer layer;
    private final InputPreProcessor layerPreProcessor;
    private boolean setLayerInput;

    public LayerVertex(ComputationGraph graph, String name, int vertexIndex, Layer layer, InputPreProcessor layerPreProcessor, boolean outputVertex, DataType dataType) {
        this(graph, name, vertexIndex, null, null, layer, layerPreProcessor, outputVertex, dataType);
    }

    public LayerVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, Layer layer, InputPreProcessor layerPreProcessor, boolean outputVertex, DataType dataType) {
        super(graph, name, vertexIndex, inputVertices, outputVertices, dataType);
        this.graph = graph;
        this.vertexName = name;
        this.vertexIndex = vertexIndex;
        this.inputVertices = inputVertices;
        this.outputVertices = outputVertices;
        this.layer = layer;
        this.layerPreProcessor = layerPreProcessor;
        this.outputVertex = outputVertex;
        this.inputs = new INDArray[inputVertices != null ? inputVertices.length : 0];
    }

    @Override
    public boolean hasLayer() {
        return true;
    }

    @Override
    public void setLayerAsFrozen() {
        if (this.layer instanceof FrozenLayer) {
            return;
        }
        this.layer = new FrozenLayer(this.layer);
        this.layer.conf().getLayer().setLayerName(this.vertexName);
    }

    @Override
    public Map<String, INDArray> paramTable(boolean backpropOnly) {
        return this.layer.paramTable(backpropOnly);
    }

    @Override
    public boolean isOutputVertex() {
        return this.outputVertex || this.layer instanceof BaseOutputLayer;
    }

    @Override
    public Layer getLayer() {
        return this.layer;
    }

    @Override
    public INDArray doForward(boolean training, LayerWorkspaceMgr workspaceMgr) {
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: all inputs not set");
        }
        return this.layer.activate(training, workspaceMgr);
    }

    public void applyPreprocessorAndSetInput(LayerWorkspaceMgr workspaceMgr) {
        INDArray currInput = this.inputs[0];
        if (this.layerPreProcessor != null) {
            currInput = this.layerPreProcessor.preProcess(currInput, this.graph.batchSize(), workspaceMgr);
        }
        this.layer.setInput(currInput, workspaceMgr);
        this.setLayerInput = true;
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt, LayerWorkspaceMgr workspaceMgr) {
        if (!this.canDoBackward()) {
            if (this.inputs == null || this.inputs[0] == null) {
                throw new IllegalStateException("Cannot do backward pass: inputs not set. Layer: \"" + this.vertexName + "\" (idx " + this.vertexIndex + "), numInputs: " + this.getNumInputArrays());
            }
            throw new IllegalStateException("Cannot do backward pass: all epsilons not set. Layer \"" + this.vertexName + "\" (idx " + this.vertexIndex + "), numInputs :" + this.getNumInputArrays() + "; numOutputs: " + this.getNumOutputConnections());
        }
        if (!this.setLayerInput) {
            this.applyPreprocessorAndSetInput(workspaceMgr);
        }
        Pair<Gradient, INDArray> pair = tbptt && this.layer instanceof RecurrentLayer ? ((RecurrentLayer)this.layer).tbpttBackpropGradient(this.epsilon, this.graph.getConfiguration().getTbpttBackLength(), workspaceMgr) : this.layer.backpropGradient(this.epsilon, workspaceMgr);
        if (this.layerPreProcessor != null) {
            INDArray eps = (INDArray)pair.getSecond();
            eps = this.layerPreProcessor.backprop(eps, this.graph.batchSize(), workspaceMgr);
            pair.setSecond((Object)eps);
        }
        return new Pair((Object)((Gradient)pair.getFirst()), (Object)new INDArray[]{(INDArray)pair.getSecond()});
    }

    @Override
    public void setInput(int inputNumber, INDArray input, LayerWorkspaceMgr workspaceMgr) {
        if (inputNumber > 0) {
            throw new IllegalArgumentException("Invalid input number: LayerVertex instances have only 1 input (got inputNumber = " + inputNumber + ")");
        }
        this.inputs[inputNumber] = input;
        this.setLayerInput = false;
        this.applyPreprocessorAndSetInput(workspaceMgr);
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        this.layer.setBackpropGradientsViewArray(backpropGradientsViewArray);
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        if (maskArrays == null || maskArrays.length == 0) {
            return new Pair(null, (Object)currentMaskState);
        }
        if (this.layerPreProcessor != null) {
            Pair<INDArray, MaskState> pair = this.layerPreProcessor.feedForwardMaskArray(maskArrays[0], currentMaskState, minibatchSize);
            if (pair == null) {
                maskArrays[0] = null;
                currentMaskState = null;
            } else {
                maskArrays[0] = (INDArray)pair.getFirst();
                currentMaskState = (MaskState)((Object)pair.getSecond());
            }
        }
        return this.layer.feedForwardMaskArray(maskArrays[0], currentMaskState, minibatchSize);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LayerVertex(id=").append(this.vertexIndex).append(",name=\"").append(this.vertexName).append("\",inputs=").append(Arrays.toString(this.inputVertices)).append(",outputs=").append(Arrays.toString(this.outputVertices)).append(")");
        return sb.toString();
    }

    @Override
    public boolean canDoBackward() {
        if (!this.isOutputVertex()) {
            if (this.getLayer() instanceof FrozenLayer) {
                return true;
            }
            return super.canDoBackward();
        }
        for (INDArray input : this.inputs) {
            if (input != null) continue;
            return false;
        }
        Layer resolvedLayer = this.layer;
        if (this.layer instanceof FrozenLayerWithBackprop) {
            resolvedLayer = ((FrozenLayerWithBackprop)this.layer).getInsideLayer();
        }
        return resolvedLayer instanceof IOutputLayer || this.epsilon != null;
    }

    public double computeScore(double r, boolean training, LayerWorkspaceMgr workspaceMgr) {
        if (!(this.layer instanceof IOutputLayer)) {
            throw new UnsupportedOperationException("Cannot compute score: layer is not an output layer (layer class: " + this.layer.getClass().getSimpleName());
        }
        if (!this.setLayerInput) {
            this.applyPreprocessorAndSetInput(LayerWorkspaceMgr.noWorkspaces());
        }
        IOutputLayer ol = (IOutputLayer)this.layer;
        return ol.computeScore(r, training, workspaceMgr);
    }

    public INDArray computeScoreForExamples(double r, LayerWorkspaceMgr workspaceMgr) {
        if (!(this.layer instanceof IOutputLayer)) {
            throw new UnsupportedOperationException("Cannot compute score: layer is not an output layer (layer class: " + this.layer.getClass().getSimpleName());
        }
        if (!this.setLayerInput) {
            this.applyPreprocessorAndSetInput(workspaceMgr);
        }
        IOutputLayer ol = (IOutputLayer)this.layer;
        return ol.computeScoreForExamples(r, workspaceMgr);
    }

    @Override
    public TrainingConfig getConfig() {
        return this.getLayer().getConfig();
    }

    @Override
    public INDArray params() {
        return this.layer.params();
    }

    @Override
    public INDArray getGradientsViewArray() {
        return this.layer.getGradientsViewArray();
    }

    public InputPreProcessor getLayerPreProcessor() {
        return this.layerPreProcessor;
    }

    public boolean isSetLayerInput() {
        return this.setLayerInput;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public void setSetLayerInput(boolean setLayerInput) {
        this.setLayerInput = setLayerInput;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LayerVertex)) {
            return false;
        }
        LayerVertex other = (LayerVertex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSetLayerInput() != other.isSetLayerInput()) {
            return false;
        }
        Layer this$layer = this.getLayer();
        Layer other$layer = other.getLayer();
        if (this$layer == null ? other$layer != null : !this$layer.equals(other$layer)) {
            return false;
        }
        InputPreProcessor this$layerPreProcessor = this.getLayerPreProcessor();
        InputPreProcessor other$layerPreProcessor = other.getLayerPreProcessor();
        return !(this$layerPreProcessor == null ? other$layerPreProcessor != null : !this$layerPreProcessor.equals(other$layerPreProcessor));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LayerVertex;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSetLayerInput() ? 79 : 97);
        Layer $layer = this.getLayer();
        result = result * 59 + ($layer == null ? 43 : $layer.hashCode());
        InputPreProcessor $layerPreProcessor = this.getLayerPreProcessor();
        result = result * 59 + ($layerPreProcessor == null ? 43 : $layerPreProcessor.hashCode());
        return result;
    }
}

