/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.RNNFormat;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.BaseOutputLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.params.DefaultParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationSoftmax;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class RnnOutputLayer
extends BaseOutputLayer {
    private RNNFormat rnnDataFormat;

    private RnnOutputLayer(Builder builder) {
        super(builder);
        this.initializeConstraints(builder);
        this.rnnDataFormat = builder.rnnDataFormat;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        LayerValidation.assertNInNOutSet("RnnOutputLayer", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        org.deeplearning4j.nn.layers.recurrent.RnnOutputLayer ret = new org.deeplearning4j.nn.layers.recurrent.RnnOutputLayer(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return DefaultParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input type for RnnOutputLayer (layer index = " + layerIndex + ", layer name=\"" + this.getLayerName() + "\"): Expected RNN input, got " + inputType);
        }
        InputType.InputTypeRecurrent itr = (InputType.InputTypeRecurrent)inputType;
        return InputType.recurrent(this.nOut, itr.getTimeSeriesLength(), itr.getFormat());
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        if (inputType == null || inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input type for RnnOutputLayer (layer name=\"" + this.getLayerName() + "\"): Expected RNN input, got " + inputType);
        }
        InputType.InputTypeRecurrent r = (InputType.InputTypeRecurrent)inputType;
        if (this.rnnDataFormat == null || override) {
            this.rnnDataFormat = r.getFormat();
        }
        if (this.nIn <= 0L || override) {
            this.nIn = r.getSize();
        }
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        return InputTypeUtil.getPreprocessorForInputTypeRnnLayers(inputType, this.rnnDataFormat, this.getLayerName());
    }

    public RNNFormat getRnnDataFormat() {
        return this.rnnDataFormat;
    }

    public void setRnnDataFormat(RNNFormat rnnDataFormat) {
        this.rnnDataFormat = rnnDataFormat;
    }

    public RnnOutputLayer() {
    }

    @Override
    public String toString() {
        return "RnnOutputLayer(super=" + super.toString() + ", rnnDataFormat=" + this.getRnnDataFormat() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RnnOutputLayer)) {
            return false;
        }
        RnnOutputLayer other = (RnnOutputLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RNNFormat this$rnnDataFormat = this.getRnnDataFormat();
        RNNFormat other$rnnDataFormat = other.getRnnDataFormat();
        return !(this$rnnDataFormat == null ? other$rnnDataFormat != null : !this$rnnDataFormat.equals(other$rnnDataFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RnnOutputLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        RNNFormat $rnnDataFormat = this.getRnnDataFormat();
        result = result * 59 + ($rnnDataFormat == null ? 43 : $rnnDataFormat.hashCode());
        return result;
    }

    public static class Builder
    extends BaseOutputLayer.Builder<Builder> {
        private RNNFormat rnnDataFormat;

        public Builder() {
            this.setActivationFn((IActivation)new ActivationSoftmax());
        }

        public Builder(LossFunctions.LossFunction lossFunction) {
            this.lossFunction(lossFunction);
            this.setActivationFn((IActivation)new ActivationSoftmax());
        }

        public Builder(ILossFunction lossFunction) {
            this.setLossFn(lossFunction);
            this.setActivationFn((IActivation)new ActivationSoftmax());
        }

        @Override
        public RnnOutputLayer build() {
            return new RnnOutputLayer(this);
        }

        public Builder dataFormat(RNNFormat rnnDataFormat) {
            this.rnnDataFormat = rnnDataFormat;
            return this;
        }
    }
}

