/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.RNNFormat;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.EmbeddingLayerParamInitializer;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.deeplearning4j.nn.weights.embeddings.ArrayEmbeddingInitializer;
import org.deeplearning4j.nn.weights.embeddings.EmbeddingInitializer;
import org.deeplearning4j.nn.weights.embeddings.WeightInitEmbedding;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.activations.impl.ActivationIdentity;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class EmbeddingSequenceLayer
extends FeedForwardLayer {
    private int inputLength = 1;
    private boolean hasBias = false;
    private boolean inferInputLength = false;
    private RNNFormat outputFormat = RNNFormat.NCW;

    private EmbeddingSequenceLayer(Builder builder) {
        super(builder);
        this.hasBias = builder.hasBias;
        this.inputLength = builder.inputLength;
        this.inferInputLength = builder.inferInputLength;
        this.outputFormat = builder.outputFormat;
        this.initializeConstraints(builder);
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        org.deeplearning4j.nn.layers.feedforward.embedding.EmbeddingSequenceLayer ret = new org.deeplearning4j.nn.layers.feedforward.embedding.EmbeddingSequenceLayer(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.FF && inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input for Embedding layer (layer index = " + layerIndex + ", layer name = \"" + this.getLayerName() + "\"): expect FF/RNN input type. Got: " + inputType);
        }
        return InputType.recurrent(this.nOut, this.inputLength, this.outputFormat);
    }

    @Override
    public ParamInitializer initializer() {
        return EmbeddingLayerParamInitializer.getInstance();
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        long actElementsPerEx = outputType.arrayElementsPerExample();
        long numParams = this.initializer().numParams(this);
        int updaterStateSize = (int)this.getIUpdater().stateSize(numParams);
        return new LayerMemoryReport.Builder(this.layerName, EmbeddingSequenceLayer.class, inputType, outputType).standardMemory(numParams, updaterStateSize).workingMemory(0L, 0L, 0L, actElementsPerEx).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public boolean hasBias() {
        return this.hasBias;
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for layer (layer name = \"" + this.getLayerName() + "\"): input type is null");
        }
        if (inputType.getType() == InputType.Type.RNN) {
            return null;
        }
        return super.getPreProcessorForInputType(inputType);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        if (inputType.getType() == InputType.Type.RNN) {
            if (this.nIn <= 0L || override) {
                InputType.InputTypeRecurrent f = (InputType.InputTypeRecurrent)inputType;
                this.nIn = f.getSize();
            }
        } else if (inputType.getType() == InputType.Type.FF) {
            if (this.nIn <= 0L || override) {
                InputType.InputTypeFeedForward feedForward = (InputType.InputTypeFeedForward)inputType;
                this.nIn = feedForward.getSize();
                this.inferInputLength = true;
            }
        } else {
            super.setNIn(inputType, override);
        }
    }

    public int getInputLength() {
        return this.inputLength;
    }

    public boolean isHasBias() {
        return this.hasBias;
    }

    public boolean isInferInputLength() {
        return this.inferInputLength;
    }

    public RNNFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setInputLength(int inputLength) {
        this.inputLength = inputLength;
    }

    public void setHasBias(boolean hasBias) {
        this.hasBias = hasBias;
    }

    public void setInferInputLength(boolean inferInputLength) {
        this.inferInputLength = inferInputLength;
    }

    public void setOutputFormat(RNNFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public EmbeddingSequenceLayer() {
    }

    @Override
    public String toString() {
        return "EmbeddingSequenceLayer(super=" + super.toString() + ", inputLength=" + this.getInputLength() + ", hasBias=" + this.isHasBias() + ", inferInputLength=" + this.isInferInputLength() + ", outputFormat=" + this.getOutputFormat() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddingSequenceLayer)) {
            return false;
        }
        EmbeddingSequenceLayer other = (EmbeddingSequenceLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getInputLength() != other.getInputLength()) {
            return false;
        }
        if (this.isHasBias() != other.isHasBias()) {
            return false;
        }
        if (this.isInferInputLength() != other.isInferInputLength()) {
            return false;
        }
        RNNFormat this$outputFormat = this.getOutputFormat();
        RNNFormat other$outputFormat = other.getOutputFormat();
        return !(this$outputFormat == null ? other$outputFormat != null : !this$outputFormat.equals(other$outputFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EmbeddingSequenceLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getInputLength();
        result = result * 59 + (this.isHasBias() ? 79 : 97);
        result = result * 59 + (this.isInferInputLength() ? 79 : 97);
        RNNFormat $outputFormat = this.getOutputFormat();
        result = result * 59 + ($outputFormat == null ? 43 : $outputFormat.hashCode());
        return result;
    }

    public static class Builder
    extends FeedForwardLayer.Builder<Builder> {
        private boolean hasBias = false;
        private int inputLength = 1;
        private boolean inferInputLength = true;
        private RNNFormat outputFormat = RNNFormat.NCW;

        public Builder() {
            this.activationFn = new ActivationIdentity();
        }

        public Builder outputDataFormat(RNNFormat format) {
            this.outputFormat = format;
            return this;
        }

        public Builder hasBias(boolean hasBias) {
            this.setHasBias(hasBias);
            return this;
        }

        public Builder inputLength(int inputLength) {
            this.setInputLength(inputLength);
            return this;
        }

        public Builder inferInputLength(boolean inferInputLength) {
            this.setInferInputLength(inferInputLength);
            return this;
        }

        @Override
        public Builder weightInit(IWeightInit weightInit) {
            this.setWeightInitFn(weightInit);
            return this;
        }

        @Override
        public void setWeightInitFn(IWeightInit weightInit) {
            if (weightInit instanceof WeightInitEmbedding) {
                long[] shape = ((WeightInitEmbedding)weightInit).shape();
                this.nIn(shape[0]);
                this.nOut(shape[1]);
            }
            this.weightInitFn = weightInit;
        }

        public Builder weightInit(EmbeddingInitializer embeddingInitializer) {
            return this.weightInit(new WeightInitEmbedding(embeddingInitializer));
        }

        public Builder weightInit(INDArray vectors) {
            return this.weightInit(new ArrayEmbeddingInitializer(vectors));
        }

        @Override
        public EmbeddingSequenceLayer build() {
            return new EmbeddingSequenceLayer(this);
        }

        public boolean isHasBias() {
            return this.hasBias;
        }

        public int getInputLength() {
            return this.inputLength;
        }

        public boolean isInferInputLength() {
            return this.inferInputLength;
        }

        public RNNFormat getOutputFormat() {
            return this.outputFormat;
        }

        public void setHasBias(boolean hasBias) {
            this.hasBias = hasBias;
        }

        public void setInputLength(int inputLength) {
            this.inputLength = inputLength;
        }

        public void setInferInputLength(boolean inferInputLength) {
            this.inferInputLength = inferInputLength;
        }

        public void setOutputFormat(RNNFormat outputFormat) {
            this.outputFormat = outputFormat;
        }
    }
}

