/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import lombok.NonNull;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.BaseOutputLayer;
import org.deeplearning4j.nn.conf.layers.Convolution3D;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.lossfunctions.ILossFunction;

public class Cnn3DLossLayer
extends FeedForwardLayer {
    protected ILossFunction lossFn;
    protected Convolution3D.DataFormat dataFormat;

    private Cnn3DLossLayer(Builder builder) {
        super(builder);
        this.lossFn = builder.lossFn;
        this.dataFormat = builder.dataFormat;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        org.deeplearning4j.nn.layers.convolution.Cnn3DLossLayer ret = new org.deeplearning4j.nn.layers.convolution.Cnn3DLossLayer(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN3D && inputType.getType() != InputType.Type.CNNFlat) {
            throw new IllegalStateException("Invalid input type for CnnLossLayer (layer index = " + layerIndex + ", layer name=\"" + this.getLayerName() + "\"): Expected CNN3D or CNNFlat input, got " + inputType);
        }
        return inputType;
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        return InputTypeUtil.getPreProcessorForInputTypeCnn3DLayers(inputType, this.getLayerName());
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        return new LayerMemoryReport.Builder(this.layerName, this.getClass(), inputType, inputType).standardMemory(0L, 0L).workingMemory(0L, 0L, 0L, 0L).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    public ILossFunction getLossFn() {
        return this.lossFn;
    }

    public Convolution3D.DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setLossFn(ILossFunction lossFn) {
        this.lossFn = lossFn;
    }

    public void setDataFormat(Convolution3D.DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public Cnn3DLossLayer() {
    }

    @Override
    public String toString() {
        return "Cnn3DLossLayer(super=" + super.toString() + ", lossFn=" + this.getLossFn() + ", dataFormat=" + this.getDataFormat() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cnn3DLossLayer)) {
            return false;
        }
        Cnn3DLossLayer other = (Cnn3DLossLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ILossFunction this$lossFn = this.getLossFn();
        ILossFunction other$lossFn = other.getLossFn();
        if (this$lossFn == null ? other$lossFn != null : !this$lossFn.equals(other$lossFn)) {
            return false;
        }
        Convolution3D.DataFormat this$dataFormat = this.getDataFormat();
        Convolution3D.DataFormat other$dataFormat = other.getDataFormat();
        return !(this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Cnn3DLossLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ILossFunction $lossFn = this.getLossFn();
        result = result * 59 + ($lossFn == null ? 43 : $lossFn.hashCode());
        Convolution3D.DataFormat $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        return result;
    }

    public static class Builder
    extends BaseOutputLayer.Builder<Builder> {
        protected Convolution3D.DataFormat dataFormat;

        public Builder(@NonNull Convolution3D.DataFormat format) {
            if (format == null) {
                throw new NullPointerException("format is marked non-null but is null");
            }
            this.setDataFormat(format);
            this.setActivationFn(Activation.IDENTITY.getActivationFunction());
        }

        @Override
        public Builder nIn(int nIn) {
            throw new UnsupportedOperationException("Cnn3DLossLayer has no parameters, thus nIn will always equal nOut.");
        }

        @Override
        public Builder nOut(int nOut) {
            throw new UnsupportedOperationException("Cnn3DLossLayer has no parameters, thus nIn will always equal nOut.");
        }

        @Override
        public void setNIn(long nIn) {
            throw new UnsupportedOperationException("Cnn3DLossLayer has no parameters, thus nIn will always equal nOut.");
        }

        @Override
        public void setNOut(long nOut) {
            throw new UnsupportedOperationException("Cnn3DLossLayer has no parameters, thus nIn will always equal nOut.");
        }

        @Override
        public Cnn3DLossLayer build() {
            return new Cnn3DLossLayer(this);
        }

        public Convolution3D.DataFormat getDataFormat() {
            return this.dataFormat;
        }

        public void setDataFormat(Convolution3D.DataFormat dataFormat) {
            this.dataFormat = dataFormat;
        }
    }
}

