/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.distribution;

import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class BinomialDistribution
extends Distribution {
    private static final long serialVersionUID = 7407024251874318749L;
    private final int numberOfTrials;
    private double probabilityOfSuccess;

    @JsonCreator
    public BinomialDistribution(@JsonProperty(value="numberOfTrials") int numberOfTrials, @JsonProperty(value="probabilityOfSuccess") double probabilityOfSuccess) {
        this.numberOfTrials = numberOfTrials;
        this.probabilityOfSuccess = probabilityOfSuccess;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public void setProbabilityOfSuccess(double probabilityOfSuccess) {
        this.probabilityOfSuccess = probabilityOfSuccess;
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.numberOfTrials;
        long temp = Double.doubleToLongBits(this.probabilityOfSuccess);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinomialDistribution other = (BinomialDistribution)obj;
        if (this.numberOfTrials != other.numberOfTrials) {
            return false;
        }
        return Double.doubleToLongBits(this.probabilityOfSuccess) == Double.doubleToLongBits(other.probabilityOfSuccess);
    }

    public String toString() {
        return "BinomialDistribution(numberOfTrials=" + this.numberOfTrials + ", probabilityOfSuccess=" + this.probabilityOfSuccess + ")";
    }
}

