/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.iterator.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import lombok.NonNull;
import org.deeplearning4j.iterator.LabeledSentenceProvider;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.MathUtils;

public class CollectionLabeledSentenceProvider
implements LabeledSentenceProvider {
    private final List<String> sentences;
    private final List<String> labels;
    private final Random rng;
    private final int[] order;
    private final List<String> allLabels;
    private int cursor = 0;

    public CollectionLabeledSentenceProvider(@NonNull List<String> sentences, @NonNull List<String> labelsForSentences) {
        this(sentences, labelsForSentences, new Random());
        if (sentences == null) {
            throw new NullPointerException("sentences is marked @NonNull but is null");
        }
        if (labelsForSentences == null) {
            throw new NullPointerException("labelsForSentences is marked @NonNull but is null");
        }
    }

    public CollectionLabeledSentenceProvider(@NonNull List<String> sentences, @NonNull List<String> labelsForSentences, Random rng) {
        if (sentences == null) {
            throw new NullPointerException("sentences is marked @NonNull but is null");
        }
        if (labelsForSentences == null) {
            throw new NullPointerException("labelsForSentences is marked @NonNull but is null");
        }
        if (sentences.size() != labelsForSentences.size()) {
            throw new IllegalArgumentException("Sentences and labels must be same size (sentences size: " + sentences.size() + ", labels size: " + labelsForSentences.size() + ")");
        }
        this.sentences = sentences;
        this.labels = labelsForSentences;
        this.rng = rng;
        if (rng == null) {
            this.order = null;
        } else {
            this.order = new int[sentences.size()];
            for (int i = 0; i < sentences.size(); ++i) {
                this.order[i] = i;
            }
            MathUtils.shuffleArray((int[])this.order, (Random)rng);
        }
        HashSet<String> uniqueLabels = new HashSet<String>(labelsForSentences);
        this.allLabels = new ArrayList<String>(uniqueLabels);
        Collections.sort(this.allLabels);
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.sentences.size();
    }

    @Override
    public Pair<String, String> nextSentence() {
        Preconditions.checkState((boolean)this.hasNext(), (String)"No next element available");
        int idx = this.rng == null ? this.cursor++ : this.order[this.cursor++];
        return new Pair((Object)this.sentences.get(idx), (Object)this.labels.get(idx));
    }

    @Override
    public void reset() {
        this.cursor = 0;
        if (this.rng != null) {
            MathUtils.shuffleArray((int[])this.order, (Random)this.rng);
        }
    }

    @Override
    public int totalNumSentences() {
        return this.sentences.size();
    }

    @Override
    public List<String> allLabels() {
        return this.allLabels;
    }

    @Override
    public int numLabelClasses() {
        return this.allLabels.size();
    }
}

