/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.metadata;

import org.apache.commons.lang3.Validate;
import org.datayoo.tripod.metadata.AbstractExpressionMetadata;
import org.datayoo.tripod.metadata.ExpressionType;

public class PhraseMetadata
extends AbstractExpressionMetadata {
    protected char enclosure;
    protected String phrase;

    public PhraseMetadata(String phrase) {
        super(ExpressionType.PHRASE);
        Validate.notEmpty((CharSequence)phrase, (String)"phrase is empty!", (Object[])new Object[0]);
        this.enclosure = phrase.charAt(0);
        this.phrase = phrase.substring(1, phrase.length() - 1);
    }

    public char getEnclosure() {
        return this.enclosure;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public String getOriginalPhrase() {
        return String.format("%c%s%c", Character.valueOf(this.enclosure), this.phrase, Character.valueOf(this.enclosure));
    }

    public String toString() {
        if (this.boost == 1) {
            return this.getOriginalPhrase();
        }
        return String.format("%s^%d", this.getOriginalPhrase(), this.boost);
    }
}

