/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.metadata;

import org.apache.commons.lang3.Validate;
import org.datayoo.tripod.metadata.AbstractExpressionMetadata;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.metadata.ExpressionType;

public class BinaryMetadata
extends AbstractExpressionMetadata {
    protected ExpressionMetadata lExpr;
    protected ExpressionMetadata rExpr;

    public BinaryMetadata(ExpressionType expressionType, ExpressionMetadata lExpr, ExpressionMetadata rExpr) {
        super(expressionType);
        if (expressionType != ExpressionType.AND && expressionType != ExpressionType.OR) {
            throw new IllegalArgumentException("Invalid expression type!");
        }
        Validate.notNull((Object)lExpr, (String)"lExpr is null!", (Object[])new Object[0]);
        Validate.notNull((Object)rExpr, (String)"rExpr is null!", (Object[])new Object[0]);
        this.lExpr = lExpr;
        this.rExpr = rExpr;
    }

    public ExpressionMetadata getlExpr() {
        return this.lExpr;
    }

    public ExpressionMetadata getrExpr() {
        return this.rExpr;
    }

    public String toString() {
        String op = " | ";
        if (this.expressionType == ExpressionType.AND) {
            op = " & ";
        }
        if (this.boost == 1) {
            return String.format("%s%s%s", this.lExpr.toString(), op, this.rExpr.toString());
        }
        return String.format("%s%s%s^%d", this.lExpr.toString(), op, this.rExpr.toString(), this.boost);
    }
}

