/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public class WildcardMatcher {
    public static final char ESCAPE_CH = '\\';
    public static final char ANY_CH = '?';
    public static final char MULTI_ANY_CH = '*';
    public static final char[] escapeChars = new char[]{'$', '(', ')', '+', '.', '[', ']', '^', '{', '}', '|', '\\', '?', '*'};
    protected Pattern pattern;

    public WildcardMatcher(String fuzzyExp) {
        Validate.notEmpty((CharSequence)fuzzyExp, (String)fuzzyExp, (Object[])new Object[0]);
        String regExp = this.trans2RegExp(fuzzyExp);
        this.pattern = Pattern.compile(regExp);
    }

    protected String trans2RegExp(String fuzzyExp) {
        StringBuffer sbuf = new StringBuffer();
        boolean escape = false;
        for (int i = 0; i < fuzzyExp.length(); ++i) {
            if (fuzzyExp.charAt(i) == '\\' && !escape) {
                escape = true;
                continue;
            }
            if (fuzzyExp.charAt(i) == '?' && !escape) {
                sbuf.append('.');
                continue;
            }
            if (fuzzyExp.charAt(i) == '*' && !escape) {
                sbuf.append(".*");
                continue;
            }
            if (WildcardMatcher.isEscapeChar(fuzzyExp.charAt(i))) {
                sbuf.append("\\");
                sbuf.append(fuzzyExp.charAt(i));
                escape = false;
                continue;
            }
            if (escape) {
                escape = false;
            }
            sbuf.append(fuzzyExp.charAt(i));
        }
        return sbuf.toString();
    }

    public boolean isMatch(String data) {
        Matcher matcher = this.pattern.matcher(data);
        return matcher.matches();
    }

    protected static boolean isEscapeChar(char ch) {
        for (int i = 0; i < escapeChars.length; ++i) {
            if (escapeChars[i] != ch) continue;
            return true;
        }
        return false;
    }
}

