/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.operand;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.datayoo.tripod.DocumentEntity;
import org.datayoo.tripod.FieldMetadata;
import org.datayoo.tripod.HitToken;
import org.datayoo.tripod.TermEntity;
import org.datayoo.tripod.TripodContext;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.operand.AbstractOperand;

public abstract class AtomOperand
extends AbstractOperand {
    protected String field;

    public AtomOperand(ExpressionMetadata expressionMetadata, TripodContext context) {
        super(expressionMetadata, context);
    }

    public AtomOperand(String field, ExpressionMetadata expressionMetadata, TripodContext context) {
        this(expressionMetadata, context);
        if (field != null) {
            this.field = field;
            if (expressionMetadata.getBoost() == 1) {
                this.boost = context.getBoost(field);
            }
        } else {
            FieldMetadata fieldMetadata = context.getDefaultField();
            this.field = fieldMetadata.getField();
            this.boost = fieldMetadata.getBoost();
        }
    }

    protected double score(DocumentEntity documentEntity, TermEntity termEntity) {
        if (!this.context.isScoring()) {
            return 1.0;
        }
        double tf = this.getTf(documentEntity, termEntity);
        double idf = this.context.getIdf(termEntity.getTerm());
        double lengthNorm = this.lengthNorm(documentEntity);
        return tf * idf * idf * (double)this.boost * lengthNorm;
    }

    protected double getTf(DocumentEntity documentEntity, TermEntity termEntity) {
        return documentEntity.getTermFrequency(termEntity.getTerm());
    }

    protected double lengthNorm(DocumentEntity documentEntity) {
        return (double)this.boost * (1.0 / Math.sqrt(documentEntity.getTermsCount()));
    }

    protected List<HitToken> getHits(Map<String, List<HitToken>> hitMap, String field) {
        if (hitMap == null) {
            return null;
        }
        List<HitToken> hits = hitMap.get(field);
        if (hits == null) {
            hits = new LinkedList<HitToken>();
            hitMap.put(field, hits);
        }
        return hits;
    }

    @Override
    public ExpressionMetadata getMetadata() {
        return this.expressionMetadata;
    }
}

