/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.logic;

import java.util.List;
import java.util.Map;
import org.datayoo.tripod.DocumentEntity;
import org.datayoo.tripod.HitToken;
import org.datayoo.tripod.Operand;
import org.datayoo.tripod.TripodContext;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.operand.DecratorOperand;

public class AndOperand
extends DecratorOperand {
    protected Operand lOperand;
    protected Operand rOperand;

    public AndOperand(List<Operand> operands, ExpressionMetadata expressionMetadata, TripodContext context) {
        super(operands, expressionMetadata, context);
        if (operands.size() != 2) {
            throw new IllegalArgumentException("Invalid and operand!");
        }
        this.lOperand = operands.get(0);
        this.rOperand = operands.get(1);
    }

    @Override
    public double operate(DocumentEntity documentEntity, boolean termDistance, Map<String, List<HitToken>> hitMap) {
        double lScore = this.lOperand.operate(documentEntity, termDistance, hitMap);
        if (lScore < 0.0) {
            return -1.0;
        }
        double rScore = this.rOperand.operate(documentEntity, termDistance, hitMap);
        if (rScore < 0.0) {
            return -1.0;
        }
        if (this.context.isScoring()) {
            return (lScore + rScore) * (double)this.boost;
        }
        return 1.0;
    }
}

