/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.engine;

import org.datayoo.tripod.metadata.BinaryMetadata;
import org.datayoo.tripod.metadata.BoolMetadata;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.metadata.ExpressionType;
import org.datayoo.tripod.metadata.FieldMetadata;
import org.datayoo.tripod.metadata.PhraseMetadata;
import org.datayoo.tripod.metadata.RangeMetadata;
import org.datayoo.tripod.metadata.SuffixMetadata;
import org.datayoo.tripod.metadata.TermMetadata;
import org.datayoo.tripod.metadata.UnaryMetadata;
import org.datayoo.tripod.metadata.WildcardMetadata;
import org.datayoo.tripod.parser.TripodExpressionParser;
import org.datayoo.tripod.utils.DoubleFormater;

public class TripodEvaluator {
    protected double unit = 1.0;
    protected double mustCoefficent = 1.0;
    protected double shouldCoefficent = 1.2;
    protected double phraseCoefficent = 8.0;
    protected double rangeCoefficent = 1.1;
    protected double fuzzyCoefficent = 4.0;
    protected double wildcardCoefficent = 8.0;
    protected double parenCoefficent = 1.0;
    protected double orCoefficent = 1.0;
    protected double andCoefficent = 1.2;
    protected double notCoefficent = 1.0;

    public double complexity(String rule) {
        BoolMetadata boolMetadata = TripodExpressionParser.parseFromString((String)rule);
        return this.complexity(boolMetadata);
    }

    public double complexity(BoolMetadata boolMetadata) {
        double score = 0.0;
        for (ExpressionMetadata expressionMetadata : boolMetadata.getBoolExprs()) {
            if (expressionMetadata.getExpressionType() == ExpressionType.MUST || expressionMetadata.getExpressionType() == ExpressionType.MINUS) {
                score += this.complexity(expressionMetadata);
                continue;
            }
            score += this.complexity(expressionMetadata) * this.shouldCoefficent;
        }
        return DoubleFormater.format(score, 2);
    }

    protected double complexity(ExpressionMetadata expressionMetadata) {
        if (expressionMetadata.getExpressionType() == ExpressionType.SPACE_OR) {
            return this.complexity((BoolMetadata)expressionMetadata);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.AND) {
            return this.complexityOfAnd((BinaryMetadata)expressionMetadata);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.OR) {
            return this.complexityOfOr((BinaryMetadata)expressionMetadata);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.NOT) {
            return this.complexityOfNot((UnaryMetadata)expressionMetadata);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.MUST || expressionMetadata.getExpressionType() == ExpressionType.MINUS) {
            return this.complexityOfMust((UnaryMetadata)expressionMetadata);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.FIELD) {
            FieldMetadata fieldMetadata = (FieldMetadata)expressionMetadata;
            return this.complexity(fieldMetadata.getField());
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.PAREN) {
            UnaryMetadata unaryMetadata = (UnaryMetadata)expressionMetadata;
            return this.complexityOfParen(unaryMetadata);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.RANGE) {
            RangeMetadata rangeMetadata = (RangeMetadata)expressionMetadata;
            return this.complexity((ExpressionMetadata)rangeMetadata);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.PHRASE || expressionMetadata.getExpressionType() == ExpressionType.PROXIMITY) {
            return this.complexityOfPhrase(expressionMetadata);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.WILDCARD) {
            WildcardMetadata wildcardMetadata = (WildcardMetadata)expressionMetadata;
            return this.complexity(wildcardMetadata);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.FUZZY) {
            SuffixMetadata suffixMetadata = (SuffixMetadata)expressionMetadata;
            return this.complexity(suffixMetadata);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.TERM) {
            TermMetadata termMetadata = (TermMetadata)expressionMetadata;
            return this.complexity(termMetadata);
        }
        throw new IllegalArgumentException(String.format("Invalid expression type '%s'!", expressionMetadata.getExpressionType()));
    }

    protected double complexityOfAnd(BinaryMetadata andMetadata) {
        double score = 0.0;
        score = this.complexity(andMetadata.getlExpr());
        return (score += this.complexity(andMetadata.getrExpr())) * this.andCoefficent;
    }

    protected double complexityOfOr(BinaryMetadata orMetadata) {
        double score = 0.0;
        score = this.complexity(orMetadata.getlExpr());
        return (score += this.complexity(orMetadata.getrExpr())) * this.orCoefficent;
    }

    protected double complexityOfNot(UnaryMetadata unaryMetadata) {
        double score = 0.0;
        score = this.complexity(unaryMetadata.getExpr());
        return score * this.notCoefficent;
    }

    protected double complexityOfParen(UnaryMetadata unaryMetadata) {
        double score = 0.0;
        score = this.complexity(unaryMetadata.getExpr());
        return score * this.parenCoefficent;
    }

    protected double complexityOfMust(UnaryMetadata unaryMetadata) {
        double score = 0.0;
        score = this.complexity(unaryMetadata.getExpr());
        return score * this.mustCoefficent;
    }

    protected double complexity(TermMetadata termMetadata) {
        return this.unit;
    }

    protected double complexity(WildcardMetadata wildcardMetadata) {
        return this.unit * this.wildcardCoefficent;
    }

    protected double complexity(SuffixMetadata suffixMetadata) {
        return this.unit * this.fuzzyCoefficent;
    }

    protected double complexityOfPhrase(ExpressionMetadata expressionMetadata) {
        if (expressionMetadata instanceof SuffixMetadata) {
            expressionMetadata = ((SuffixMetadata)expressionMetadata).getExpr();
        }
        PhraseMetadata phraseMetadata = (PhraseMetadata)expressionMetadata;
        String[] terms = phraseMetadata.getPhrase().split(" ");
        return (double)terms.length * this.unit * this.phraseCoefficent;
    }

    protected double createRangeOperand(RangeMetadata rangeMetadata) {
        return this.unit * this.rangeCoefficent;
    }

    public TripodEvaluator setUnit(double unit) {
        this.unit = unit;
        return this;
    }

    public TripodEvaluator setMustCoefficent(double mustCoefficent) {
        this.mustCoefficent = mustCoefficent;
        return this;
    }

    public TripodEvaluator setShouldCoefficent(double shouldCoefficent) {
        this.shouldCoefficent = shouldCoefficent;
        return this;
    }

    public TripodEvaluator setPhraseCoefficent(double distanceCoefficent) {
        this.phraseCoefficent = this.phraseCoefficent;
        return this;
    }

    public TripodEvaluator setRangeCoefficent(double rangeCoefficent) {
        this.rangeCoefficent = rangeCoefficent;
        return this;
    }

    public TripodEvaluator setFuzzyCoefficent(double fuzzyCoefficent) {
        this.fuzzyCoefficent = fuzzyCoefficent;
        return this;
    }

    public TripodEvaluator setWildcardCoefficent(double wildcardCoefficent) {
        this.wildcardCoefficent = wildcardCoefficent;
        return this;
    }

    public TripodEvaluator setParenCoefficent(double parenCoefficent) {
        this.parenCoefficent = parenCoefficent;
        return this;
    }

    public TripodEvaluator setOrCoefficent(double orCoefficent) {
        this.orCoefficent = orCoefficent;
        return this;
    }

    public TripodEvaluator setAndCoefficent(double andCoefficent) {
        this.andCoefficent = andCoefficent;
        return this;
    }

    public TripodEvaluator setNotCoefficent(double notCoefficent) {
        this.notCoefficent = notCoefficent;
        return this;
    }
}

